/* param.c - statical values:  - emx/gcc */
/* $Id: param.c,v 1.8 2000/05/02 07:44:52 veit Exp $ */

#define INCL_DOSFILEMGR
#define INCL_DOSMISC
#include <os2.h>

#include <sys/param.h>
#include <sys/time.h>
#include <sys/systm.h>
#include <sys/socket.h>
#include <sys/proc.h>
#include <sys/kernel.h>
#include <sys/file.h>
#include <sys/callout.h>
#include <errno.h>
#include <sys/errnox.h>
#include <stdlib.h>
#include <unistd.h>
#include <paths.h>

#ifdef REAL_CLISTS
#include <sys/clist.h>
#endif

#if 0
#include <sys/mbuf.h>
#include <ufs/ufs/quota.h>
#include <sys/utsname.h>
#endif

#ifdef SYSVSEM
#include <sys/sem.h>
#endif
#define _KERNEL
#include <sys/msg.h>

#include "../../rev.h"

/* Parts:
 * Copyright (c) 1980, 1986, 1989 Regents of the University of California.
 * All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)param.c	7.20 (Berkeley) 6/27/91
 */

/*
 * System parameter formulae.
 *
 * This file is copied into each directory where we compile
 * the kernel; it should be modified there to suit local taste
 * if necessary.
 *
 * Compiled with -D_HZ=xx -DTIME_ZONE__=x -D_DST=x -DMAXUSERS=xx
 */

int	__Param_hz = _HZ;
int	__Param_stathz = _HZ;
int	__Param_tick = 1000000 / _HZ;
int	__Param_tickadj = 240000 / (60 * _HZ);	/* can adjust 240ms in 60s */

struct	timezone __Param_tz = { TIME_ZONE__, _DST };

volatile struct timeval __Param_mono_time = {0,0};
struct timeval 		__Param_boottime  = {0,0};
struct timeval 		__Param_runtime   = {0,0};
volatile struct timeval __Param_time      = {0,0};

int	__Param_maxproc = NPROC;
int	__Param_maxfiles = 3 * (NPROC + MAXUSERS) + 80;
int	__Param_ncallout = 16 + NPROC;
#ifdef REAL_CLISTS
int	__Param_nclist = 60 + 12 * MAXUSERS;
#endif
#if 0
int	__Param_nmbclusters = NMBCLUSTERS;
int	__Param_desiredvnodes = NVNODE;
#endif
int	__Param_fscale = FSCALE;	/* kernel uses `FSCALE', user uses `fscale' */

/*
 * Values in support of System V compatible semaphores.
 */
#ifdef SYSVSEM
struct	seminfo __Param_seminfo = {
	SEMMAP,		/* # of entries in semaphore map */
	SEMMNI,		/* # of semaphore identifiers */
	SEMMNS,		/* # of semaphores in system */
	SEMMNU,		/* # of undo structures in system */
	SEMMSL,		/* max # of semaphores per id */
	SEMOPM,		/* max # of operations per semop call */
	SEMUME,		/* max # of undo entries per process */
	SEMUSZ,		/* size in bytes of undo structure */
	SEMVMX,		/* semaphore maximum value */
	SEMAEM		/* adjust on exit max value */
};
#endif

/*
 * Values in support of System V compatible messages.
 */
struct	_msginfo __Param_msginfo = {
	MSGMAX,		/* max chars in a message */
	MSGMNI,		/* # of message queue identifiers */
	MSGMNB,		/* max chars in a queue */
	MSGTQL,		/* max messages in system */
	MSGSSZ,		/* size of a message segment */
			/* (must be small power of 2 greater than 4) */
	MSGSEG		/* number of message segments */
};

/*
 * These are initialized at bootstrap time
 * to values dependent on memory size
 */
int	__Param_nbuf, __Param_nswbuf;

/*
 * These have to be allocated somewhere; allocating
 * them here forces loader errors if this file is omitted
 * (if they've been externed everywhere else; hah!).
 */
struct 	callout *__Param_callout;
struct	cblock *__Param_cfree;
struct	buf *__Param_buf, *__Param_swbuf;
char	*__Param_buffers;
#if 0
struct	utsname __Param_utsname;
#endif
/*
 * Attributes stored in the kernel.
 */
char __Param_hostname[MAXHOSTNAMELEN] = _PARAM_HOST_NAME;
int  __Param_hostnamelen = sizeof(hostname);

char __Param_domainname[MAXHOSTNAMELEN] = _PARAM_DOMAIN_NAME;
int  __Param_domainnamelen = sizeof(domainname);

long __Param_hostid = _PARAM_HOST_ID;

#ifdef INSECURE
const int __Param_securelevel = -1;
#else
int __Param_securelevel = 0;
#endif

/* the following is used externally (sysctl_hw) */
const char __Param_machine[] = 		MACHINE;    	/* cpu "architecture" */
const char __Param_machine_arch[] = 	MACHINE_ARCH;   /* machine == machine_arch */

/* Info for CTL_HW */
const char  __Param_cpu_model[] = _PARAM_CPU_MODEL;
extern const char  __Rev_version[];

	extern struct clockinfo *  /* point to statical clockinfo */
_getClockInfo(void)
{
 static struct clockinfo cl;
 ULONG _buf;
 const APIRET 
  	rc = DosQuerySysInfo(QSV_TIMER_INTERVAL, QSV_TIMER_INTERVAL,
  				&_buf, sizeof(_buf));
  	if (rc) {
		errno = _rc2Errno(rc); 
		return (struct clockinfo*)NULL;
	}
		cl.tick = _buf * 100;
		cl.hz = 10000 / _buf;
		cl.tickadj = 240000 / (60 * cl.hz);
		cl.stathz = cl.hz;
		cl.profhz = 0;
	return(&cl);
}

	extern struct timeval *  /* set bootime and return it */
_bootTime(void)
{
 time_t _buf;
 const APIRET 
	rc = DosQuerySysInfo(QSV_MS_COUNT, QSV_MS_COUNT, &_buf, sizeof(_buf));
  	if (rc) {
		errno = _rc2Errno(rc); 
		return (struct timeval*)NULL;
	}
	__Param_boottime.tv_sec = _buf / 1000;
	__Param_boottime.tv_usec = (_buf % 1000)*1000;
	return(&__Param_boottime);
}
	extern int
_setMaxFiles(int new) /* set/return maximal file handles or -1 (error) */
{
 APIRET rc;

	if (new > NOFILE_MAX) {
		errno = EPERM;
		return(-1);
	}
	rc = DosSetMaxFH(new);
	if (rc)	{
		errno = _rc2Errno(rc); 
		return(-1);
	}
	__Param_maxfiles = new;
	return(__Param_maxfiles);
}

	extern __const__ int
_mxPath(void) /* return maximal path length or -1 (error) */
{
 int _buf;
 const APIRET 
  rc = DosQuerySysInfo(QSV_MAX_PATH_LENGTH, QSV_MAX_PATH_LENGTH, 
						&_buf, sizeof(_buf));
  if (rc) {errno = _rc2Errno(rc); return(-1);}

  return(_buf);
}

static const char *__Param_PosixOS2Root = "/";

	extern const char *
_getPosixOS2Root(void)
{
	if (!(__Param_PosixOS2Root = getenv("POSIXOS2ROOT")) ) 
		fputs(
"param.c: _getPosixOS2Root(): Error: You must set the environment\n\
variable POSIXOS2ROOT to the root of your Unix-tree!\n", stderr);

	return(__Param_PosixOS2Root);
}

#undef getpagesize()
	extern const int
getpagesize(void) {return(PAGE_SIZE);}

	extern int
sethostid(long __id) /* dummy fn; cf. tcpip configuration */
{
	__Param_hostid = __id; /* overwritten by sysctl()/gethostid() */
	return (0);
}

