/* dlfcn.c -- emx/gcc -- Implementation of dlopen() interface for OS/2
   This code is released into public domain 
     */
/* $Id$    */

#define INCL_DOSMODULEMGR	/* Module Manager values */
#define INCL_DOSERRORS		/* Error values */
#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <dlfcn.h>

/* length of error message string */
#define LM_LENGTH  256

/* this is the "official" string, e.g. returned by dlerror() */
static UCHAR LoadError[LM_LENGTH] = "";

/* this is the argument to DosLoadModule, currently ignored,
   but maybe used upon debugging */
static UCHAR sysLoadError[LM_LENGTH] = "";

	void *
dlopen (const char *filename, int dummy)
{
 HMODULE DLLHandle;
 __const__ APIRET rc = DosLoadModule(sysLoadError, LM_LENGTH - 1,
		      filename, &DLLHandle);
  if (rc != NO_ERROR) {
/* fprintf (stderr, "LoadError=%s\n", LoadError); */
    sprintf (LoadError, "DosLoadModule(\"%s\") = %lu\n", filename, rc);
    return(NULL);
  }
	return (void*)DLLHandle;
}

static char buf[LM_LENGTH] = ""; 		/* temporary buffer */

	char *
dlerror(void)
{
  if (!strcmp(LoadError,"")) {
      return (char*)NULL;
  }
	strncpy(buf, LoadError, LM_LENGTH - 1);
	strcpy(LoadError, ""); /* reset the error message */
	return(buf);
}

	void *
dlsym(void *handle, __const__ char *symbol)
{
 PFN FuncAddress;  /* repository for address of the resolved symbol */
 __const__ APIRET rc = 
  DosQueryProcAddr((HMODULE)handle, 0L, symbol, &FuncAddress);

  if (!rc) 			/* no error */
    return( (void*)FuncAddress );  /* hooray, return entry point */

  else  switch (rc) {  		/* now we are in trouble */
    case ERROR_INVALID_HANDLE: {
	    sprintf (LoadError,
"DosQueryProcAddr(\"%s\")=ERROR_INVALID_HANDLE #: %lu\n", symbol, rc);
	    break;
    }
    case ERROR_ENTRY_IS_CALLGATE: {
	    sprintf (LoadError,
"DosQueryProcAddr(\"%s\")=ERROR_ENTRY_IS_CALLGATE?! #: %lu\n", symbol, rc);
	    break;
    }
    default: {
	    sprintf (LoadError, 
"DosQueryProcAddr(\"%s\") returned error code #: %lu\n", symbol, rc);
	    break;
    }
  }	/* end switch(rc) */
  return(NULL);
}

	int 
dlclose (void *handle)
{
 __const__ APIRET rc = 
  DosFreeModule((HMODULE) handle);

  if (rc != NO_ERROR) {
    sprintf (LoadError, "DosFreeModule()=%lu\n", rc);
    return 2;
  }
	strcpy(LoadError, "");  /* reset last error (if any) */
  return 0;
}

