/* sys/mman.h - emx/gcc - Definitions for BSD-style memory management. Parts: */
#ifndef _SYS_MMAN_H_
#define _SYS_MMAN_H_

#if !defined (_OS2_H) && !defined (_OS2EMX_H)
#define INCL_BASE
#define OS2_API32
#define INCL_DOSPROCESS
#define INCL_DOSMEMMGR
#include <os2.h>
#endif

#if !defined (_SYS_TYPES_H)
# warning <sys/mman.h> requires <sys/types.h>
# include <sys/types.h>
#endif
/*-
 * Copyright (c) 1982, 1986 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	from: @(#)mman.h	7.5 (Berkeley) 6/27/91
 *	mman.h,v 1.3 1993/05/20 16:22:41 cgd Exp
 */
/* largest object size 'len'; adapt to your version of OS/2! */
#define MAP_MAX		524288000 /* allow 500 MB maximum mem object */

/* Return value of `mmap' in case of an error.  */
#define MAP_FAILED	((void*)-1)

/* Protections, or-ed ('|') together */
#define	PROT_READ	PAG_READ	/* pages can be read */
#define	PROT_WRITE	PAG_WRITE	/* pages can be written */
#define	PROT_EXEC	PAG_EXECUTE	/* pages can be executed */

#if !defined(_POSIX_SOURCE)
#define	PROT_GUARD	PAG_GUARD	/* raise guard page entered condition */

/* Flags contain mapping type, sharing type and options: */
 /*  Mapping type; choose one */
# define	MAP_FILE	0x0001	/* mapped from a file or device */
# define	MAP_ANON	0x0002	/* allocated from memory, swap space */
# define	MAP_TYPE	0x000f	/* mask for type field */

 /* Sharing types; choose one */
# define	MAP_COPY	0x0020	/* "copy" region at mmap time */
#endif

#define	MAP_SHARED	0x0010	/* share changes */
#define	MAP_PRIVATE	0x0000	/* changes are private */

 /* Other flags. Unsupported: err: returns error - ign: just ignored */
#define	MAP_FIXED	0x0100	/* map addr must be exactly as requested; err */

#if !defined (_POSIX_SOURCE)
# define	MAP_NOEXTEND	0x0200	/* for MAP_FILE, don't change file size */
# define	MAP_HASSEMPHORE	0x0400	/* region may contain semaphores; ign */
# define	MAP_INHERIT	0x0800	/* region is retained after exec; ign */
#endif

#if 0 /* Advice to madvise, noops, like madvise */
#define	MADV_NORMAL	0	/* no further special treatment */
#define	MADV_RANDOM	1	/* expect random page references */
#define	MADV_SEQUENTIAL	2	/* expect sequential page references */
#define	MADV_WILLNEED	3	/* will need these pages */
#define	MADV_DONTNEED	4	/* dont need these pages */

extern int madvise(void*,size_t,int); /* stub fn */
#endif

#ifndef MAP_ANONYMOUS
# define MAP_ANONYMOUS MAP_ANON
#endif

#ifdef _POSIX_SYNCHRONIZED_IO /* ignored bits */
# define 	MS_ASYNC	0x0001
# define 	MS_SYNC		0x0002
# define	MS_INVALIDATE	0x0004
#endif

#if defined(__cplusplus)
# ifndef __inline__ 
#  define __inline__ inline
# endif
extern "C" {
#endif

extern void*_mmap(void*a,__const__ size_t l,__const__ int p,__const__ int f,int fd,off_t o);
extern int _munmap(void*,size_t);
extern int _mprotect(__const__ void*,size_t,int);
extern int _msync(__const__ void*,size_t,int);

/* Machine-dependent inline versions */
#if (!__GNUC__ || __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ <= 7))
extern void*mmap(void*a,__const__ size_t l,__const__ int p,__const__ int f,int fd,off_t o);
extern int munmap(void*,size_t);
extern int mprotect(__const__ void*,size_t,int);
extern int msync(__const__ void*,size_t,int);
# if defined (__cplusplus)
 }
# endif
#else
extern __inline__ void*mmap(void*a,__const__ size_t l,__const__ int p,__const__ int f,int fd,off_t o);
extern __inline__ int munmap(void*,size_t);
extern __inline__ int mprotect(__const__ void*,size_t,int);
extern __inline__ int msync(__const__ void*,size_t,int);
# if defined (__cplusplus)
 }
# endif
	extern __inline__ void*
mmap(void*a,__const__ size_t l,__const__ int p,__const__ int f,int fd,off_t o)
{return _mmap(a,l,p,f,fd,o);}
	extern __inline__ int 
munmap(void*a,size_t l){return _munmap(a,l);}
	extern __inline__ int
mprotect(__const__ void*a,size_t l,int p){return _mprotect(a,l,p);}
	extern __inline__ int
msync(__const__ void*a,size_t l,int f){return _msync(a,l,f);}
#endif /* !GNUC, etc. */

#ifdef _DEBUG
# include <debugx.h>
#endif

#endif /* !_SYS_MMAN_H_ */
