/* this should be in <sys/stat.h> !! */
#ifndef _SYS_STATX_H
#define _SYS_STATX_H

#include <sys/stat.h>

#if defined(__cplusplus)
# ifndef __inline__ 
#  define __inline__ inline
# endif
extern "C" {
#endif

int _lstat(const char *path, struct stat *buf);

/* Machine-dependent inline versions */
#if (!__GNUC__ || __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ <= 7))
  int lstat(const char *path, struct stat *buf);
# if defined (__cplusplus)
 }
# endif
#else
  extern __inline__ int stat(const char *, struct stat *);
  extern __inline__ int lstat(const char *, struct stat *);
# if defined (__cplusplus)
 }
# endif
		extern __inline__ int 
  stat(const char*p,struct stat*b){return _stat(p,b);}
		extern __inline__ int 
  lstat(const char*p,struct stat*b){return _lstat(p,b);}
#endif

#ifdef _DEBUG
# include <debugx.h>
#endif

#endif /* not _SYS_STAT_H */
