/* $Id$ */ /* This file is released into Public Domain */

/* chown() is in SVr4, SVID, POSIX, X/OPEN: Change owner/group of file.
   Meaningless on plain OS/2 with FAT/HPFS.
   I leave the details on other file systems for other people 
   and provide the stub only! */

#include <errno.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/unistdx.h>

	extern int
_chown(const char *file, uid_t user, gid_t group)
{
	if (!file) {
		errno = EFAULT; return(-1);
	}
	if (user < 0 || group < 0) {
		errno = EINVAL; return(-1);
	}
  _dPuts("chown(): not yet really implemented!\n");
  return (0); 	  /* If we assume we don't have any "owners" and 
     "groups" I guess it's best to keep the apps happy and return 0
     instead of indicating a failure ...
      */
}

/* fchown() is in SVr4, SVID, X/OPEN: Change owner/group of file.
   Meaningless on plain OS/2 with FAT/HPFS.
   I leave the details on other file systems for other people 
   and provide the stub only! */
	extern int
_fchown(const int fd, uid_t user, gid_t group)
{
 int htype;
	if ( ioctl(fd,FGETHTYPE,&htype) ) { 		/* is fd okay? */
		/* errno = EBADF; */ /* errno set by ioctl */
		return(-1);
	}
	if ( HT_ISDEV(htype) ) { /* cannot chown clock, ttys, etc. */
		errno = ENODEV; return(-1);
	}
 	if (user < 0 || group < 0) {
		errno = EINVAL; return(-1);
	}
	_dPuts("chown(): not yet really implemented!\n");
  return (0); 	  /* If we assume we don't have any "owners" and 
     "groups" I guess it's best to keep the apps happy and return 0
     instead of indicating a failure ...
      */
}
	extern int
chown(const char*d1,uid_t d2,gid_t d3){return _chown(d1,d2,d3);}
	extern int
fchown(const int d1,uid_t d2,gid_t d3){return _fchown(d1,d2,d3);}

