/* this should be in <sys/stat.h> !! */
#ifndef _SYS_STATX_H
#define _SYS_STATX_H

#include <sys/stat.h>

#if defined(__cplusplus)
# ifndef __inline__ 
#  define __inline__ inline
# endif
extern "C" {
#endif

int _lstat(__const__ char *path, struct stat *buf);
int _fchmod(__const__ int,__const__ mode_t);

/* Machine-dependent inline versions */
#if (!__GNUC__ || __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ <= 7))
  int lstat(__const__ char *path, struct stat *buf);
  int fchmod(__const__ int,__const__ mode_t);
# if defined (__cplusplus)
 }
# endif
#else
  extern __inline__ int fchmod(__const__ int,__const__ mode_t);
  extern __inline__ int stat(__const__ char*,struct stat*);
  extern __inline__ int lstat(__const__ char*,struct stat*);
# if defined (__cplusplus)
 }
# endif
		extern __inline__ int 
  stat(__const__ char*p,struct stat*b){return _stat(p,b);}
		extern __inline__ int 
  lstat(__const__ char*p,struct stat*b){return _lstat(p,b);}
  	extern __inline__ int
  fchmod(__const__ int f,__const__ mode_t m){return _fchmod(f,m);}

#endif

#ifdef _DEBUG
# include <debugx.h>
#endif

#endif /* not _SYS_STAT_H */
