/**** testcpfile.c: _cpFile(), symlink() **** */
#include <stdio.h>
#include <errno.h> 
#include <unistd.h>

#include "sys/unistdx.h"

int main(const int argc, const char *const argv[])
{
	if (argc != 3) {
		puts("Usage: testcpfile INFILE OUTFILE"); exit(1);
	}
	errno = 0; 		/* not crucial here, but never a bad idea */
	if ( _cpFile(argv[1], argv[2]) ) {
		fprintf(stderr, "%s <%s> <%s>: Errorlevel: %d\n", 
           	        argv[0], argv[1], argv[2], 2);
		if (errno) {
  		perror("cpfile.c"); return(2);
		}
	}
	if ( symlink(argv[2], "symlnk.tst") ) {
		fprintf(stderr, "%s <%s> <symlnk.tst>: Errorlevel: %d\n", 
           	        argv[0], argv[2], 3);
		if (errno) {
  		perror("cpfile.c"); return(3);
  	}
  }
  return(0);
}

