#define INCL_WIN
#define INCL_GPI

#include <os2.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include "launch.h"

HAB  hab;
PSZ  pszErrMsg;

char BochsRC[256][256];
int iBochsRCLastLine = 0;

int fWritingControls = 0;

int RCRead( void )
{
   FILE *fRC;

   iBochsRCLastLine = 0;
   memset( BochsRC, 0, sizeof(BochsRC) );

   fRC = fopen( "bochsrc", "r" );

   if ( !fRC )
      return 0;

   while (fgets(BochsRC[iBochsRCLastLine],255,fRC))
      {
      char *tmp;

      BochsRC[iBochsRCLastLine][strlen(BochsRC[iBochsRCLastLine])-1] = 0;
      iBochsRCLastLine++;
      }

   fclose( fRC );

   return 1;
}

int RCSave( void )
{
   FILE *fRC;
   int i;

   system( "copy bochsrc bochsrc.bak" );

   fRC = fopen( "bochsrc", "w" );

   if ( !fRC )
      return 0;

   for ( i = 0 ; i < iBochsRCLastLine ; i++ )
      fprintf( fRC, "%s\n", BochsRC[i] );

   fclose( fRC );

   return 1;
}

char *FindLine( char *pszVar, int iNum )
{
   int i, j;
   char *tmp;

   for ( i = 0; i < iBochsRCLastLine ; i++ )
      {
      if ( strnicmp(BochsRC[i],pszVar,strlen(pszVar)) )
         continue;

      tmp = BochsRC[i] + strlen(pszVar);
      while ( *tmp == ' ' )
         tmp++;

      if ( iNum > 1 )
         {
         iNum--;
         continue;
         }

      return BochsRC[i];
      }

   return 0;
}

int CopyParm( char *pszLine, char *pszParm, char *pszTarget )
{
   char *pszX;

   pszX = strstr( pszLine, pszParm );

   if ( pszX )
      {
      pszX += strlen( pszParm );

      while ( *pszX != ',' && *pszX != '#' && *pszX != ' ' && *pszX != 0 )
         {
         *pszTarget = *pszX;
         pszTarget++;
         pszX++;
         }

      *pszTarget = 0;

      return 1;
      }

   return 0;
}

char *FindBoot( int iNum, char *pszBoot )
{
   char *pszLine;

   pszLine = FindLine( "boot:", 1 );

   if ( !pszLine )
      return 0;

   if ( !CopyParm( pszLine, ": ", pszBoot ) )
      return 0;

   return pszLine;
}

void UpdateBoot( char *pszLine, char *pszBoot )
{
   strcpy( pszLine, "boot: " );
   strcat( pszLine, pszBoot );
}

char *FindRomBios( int iNum, char *pszFile, char *pszAddr )
{
   char *pszLine;

   if ( iNum == 1 )
      pszLine = FindLine( "romimage:", 1 );
   else
      pszLine = FindLine( "#romimage:", iNum-1 );

   if ( !pszLine )
      return 0;

   if ( !CopyParm( pszLine, "file=", pszFile ) )
      return 0;

   if ( !CopyParm( pszLine, "address=", pszAddr ) )
      return 0;

   return pszLine;
}

void UpdateRomBios( char *pszLine, char *pszFile, char *pszAddr )
{
   strcpy ( pszLine, "romimage: file=" );
   strcat ( pszLine, pszFile );
   strcat ( pszLine, ", address=" );
   strcat ( pszLine, pszAddr );
}

char *FindVgaBios( int iNum, char *pszFile )
{
   char *pszLine;

   if ( iNum == 1 )
      pszLine = FindLine( "vgaromimage:", 1 );
   else
      pszLine = FindLine( "#vgaromimage:", iNum-1 );

   if ( !pszLine )
      return 0;

   if ( !CopyParm( pszLine, ": ", pszFile ) )
      return 0;
   
   return pszLine;
}

void UpdateVgaBios( char *pszLine, char *pszFile )
{
   strcpy ( pszLine, "vgaromimage: " );
   strcat ( pszLine, pszFile );
}

char *FindFloppyA( int iNum, char *pszFile, char *pszStatus )
{
   char *pszLine;

   if ( iNum == 1 )
      pszLine = FindLine( "floppya:", 1 );
   else
      pszLine = FindLine( "#floppya:", iNum-1 );

   if ( !pszLine )
      return 0;

   if ( !CopyParm( pszLine, "1_44=", pszFile ) )
      return 0;

   if ( !CopyParm( pszLine, "status=", pszStatus ) )
      return 0;
   
   return pszLine;
}

void UpdateFloppyA( char *pszLine, char *pszFile, char *pszStatus )
{
   strcpy ( pszLine, "floppya: 1_44=" );
   strcat ( pszLine, pszFile );
   strcat ( pszLine, ", status=" );
   strcat ( pszLine, pszStatus );
}

char *FindFloppyB( int iNum, char *pszFile, char *pszStatus )
{
   char *pszLine;

   if ( iNum == 1 )
      pszLine = FindLine( "floppyb:", 1 );
   else
      pszLine = FindLine( "#floppyb:", iNum-1 );

   if ( !pszLine )
      return 0;

   if ( !CopyParm( pszLine, "1_44=", pszFile ) )
      return 0;

   if ( !CopyParm( pszLine, "status=", pszStatus ) )
      return 0;
   
   return pszLine;
}

void UpdateFloppyB( char *pszLine, char *pszFile, char *pszStatus )
{
   strcpy ( pszLine, "floppyb: 1_44=" );
   strcat ( pszLine, pszFile );
   strcat ( pszLine, ", status=" );
   strcat ( pszLine, pszStatus );
}

char *FindDiskC( int iNum, char *pszFile, char *pszCyl, char *pszHeads, char *pszSpt )
{
   char *pszLine;

   if ( iNum == 1 )
      pszLine = FindLine( "diskc:", 1 );
   else
      pszLine = FindLine( "#diskc:", iNum-1 );

   if ( !pszLine )
      return 0;

   if ( !CopyParm( pszLine, "file=", pszFile ) )
      return 0;

   if ( !CopyParm( pszLine, "cyl=", pszCyl ) )
      return 0;

   if ( !CopyParm( pszLine, "heads=", pszHeads ) )
      return 0;

   if ( !CopyParm( pszLine, "spt=", pszSpt ) )
      return 0;
   
   return pszLine;
}

void UpdateDiskC( char *pszLine, char *pszFile, char *pszCyl, char *pszHeads, char *pszSpt )
{
   strcpy ( pszLine, "diskc: file=" );
   strcat ( pszLine, pszFile );
   strcat ( pszLine, ", cyl=" );
   strcat ( pszLine, pszCyl );
   strcat ( pszLine, ", heads=" );
   strcat ( pszLine, pszHeads );
   strcat ( pszLine, ", spt=" );
   strcat ( pszLine, pszSpt );
}

char *FindLpt1( int iNum, char *pszFile )
{
   char *pszLine;

   if ( iNum == 1 )
      pszLine = FindLine( "lpt1:", 1 );
   else
      pszLine = FindLine( "#lpt1:", iNum-1 );

   if ( !pszLine )
      return 0;

   if ( !CopyParm( pszLine, "file=", pszFile ) )
      return 0;

   return pszLine;
}

void UpdateLpt1( char *pszLine, char *pszFile )
{
   strcpy ( pszLine, "lpt1: file=" );
   strcat ( pszLine, pszFile );
}

char *FindLpt2( int iNum, char *pszFile )
{
   char *pszLine;

   if ( iNum == 1 )
      pszLine = FindLine( "lpt2:", 1 );
   else
      pszLine = FindLine( "#lpt2:", iNum-1 );

   if ( !pszLine )
      return 0;

   if ( !CopyParm( pszLine, "file=", pszFile ) )
      return 0;
   
   return pszLine;
}

void UpdateLpt2( char *pszLine, char *pszFile )
{
   strcpy ( pszLine, "lpt2: file=" );
   strcat ( pszLine, pszFile );
}

char *FindLpt3( int iNum, char *pszFile )
{
   char *pszLine;

   if ( iNum == 1 )
      pszLine = FindLine( "lpt3:", 1 );
   else
      pszLine = FindLine( "#lpt3:", iNum-1 );

   if ( !pszLine )
      return 0;

   if ( !CopyParm( pszLine, "file=", pszFile ) )
      return 0;
   
   return pszLine;
}

void UpdateLpt3( char *pszLine, char *pszFile )
{
   strcpy ( pszLine, "lpt3: file=" );
   strcat ( pszLine, pszFile );
}

char *FindLog( int iNum, char *pszFile )
{
   char *pszLine;

   pszLine = FindLine( "log:", 1 );

   if ( !pszLine )
      return 0;

   if ( !CopyParm( pszLine, ": ", pszFile ) )
      return 0;
   
   return pszLine;
}

void UpdateLog( char *pszLine, char *pszFile )
{
   strcpy ( pszLine, "log: " );
   strcat ( pszLine, pszFile );
}

char *FindMem( int iNum, char *pszMem )
{
   char *pszLine;

   pszLine = FindLine( "megs:", 1 );

   if ( !pszLine )
      return 0;

   if ( !CopyParm( pszLine, ": ", pszMem ) )
      return 0;
   
   return pszLine;
}

void UpdateMem( char *pszLine, char *pszMem )
{
   strcpy ( pszLine, "megs: " );
   strcat ( pszLine, pszMem );
}

char *FindIps( int iNum, char *pszIps )
{
   char *pszLine;

   pszLine = FindLine( "ips:", 1 );

   if ( !pszLine )
      return 0;

   if ( !CopyParm( pszLine, ": ", pszIps ) )
      return 0;
   
   return pszLine;
}

void UpdateIps( char *pszLine, char *pszIps )
{
   strcpy ( pszLine, "ips: " );
   strcat ( pszLine, pszIps );
}

char *FindFcd( int iNum, char *pszFcd )
{
   char *pszLine;

   pszLine = FindLine( "floppy_command_delay:", 1 );

   if ( !pszLine )
      return 0;

   if ( !CopyParm( pszLine, ": ", pszFcd ) )
      return 0;
   
   return pszLine;
}

void UpdateFcd( char *pszLine, char *pszFcd )
{
   strcpy ( pszLine, "floppy_command_delay: " );
   strcat ( pszLine, pszFcd );
}

char *FindKsd( int iNum, char *pszKsd )
{
   char *pszLine;

   pszLine = FindLine( "keyboard_serial_delay:", 1 );

   if ( !pszLine )
      return 0;

   if ( !CopyParm( pszLine, ": ", pszKsd ) )
      return 0;
   
   return pszLine;
}

void UpdateKsd( char *pszLine, char *pszKsd )
{
   strcpy ( pszLine, "keyboard_serial_delay: " );
   strcat ( pszLine, pszKsd );
}

char *FindVui( int iNum, char *pszVui )
{
   char *pszLine;

   pszLine = FindLine( "vga_update_interval:", 1 );

   if ( !pszLine )
      return 0;

   if ( !CopyParm( pszLine, ": ", pszVui ) )
      return 0;
   
   return pszLine;
}

void UpdateVui( char *pszLine, char *pszVui )
{
   strcpy ( pszLine, "vga_update_interval: " );
   strcat ( pszLine, pszVui );
}

char *FindVideoMode( int iNum, char *pszVideoMode )
{
   char *pszLine;

   pszLine = FindLine( "videomode:", 1 );

   if ( !pszLine )
      return 0;

   if ( !CopyParm( pszLine, ": ", pszVideoMode ) )
      return 0;
   
   return pszLine;
}

void UpdateVideoMode( char *pszLine, char *pszVideoMode )
{
   strcpy ( pszLine, "videomode: " );
   strcat ( pszLine, pszVideoMode );
}

VOID WriteControls( HWND hwnd )
{
   char *pszLine;
   int iNext;
   char szVal1[256];
   char szVal2[256];
   char szVal3[256];
   char szVal4[256];

   fWritingControls = 1 ;

   if ( ( pszLine = FindRomBios( 1, szVal1, szVal2 ) ) != 0 )
      {
      WinSendDlgItemMsg( hwnd, ID_DD_ROM_BIOS, LM_INSERTITEM, MPFROMLONG(LIT_END), szVal1 );
      WinSendDlgItemMsg( hwnd, ID_DD_ROM_BIOS, LM_SELECTITEM, MPFROMLONG(0), MPFROMLONG(TRUE) );
      WinSendDlgItemMsg( hwnd, ID_DD_ROM_BIOS, LM_SETITEMHANDLE, MPFROMLONG(0), MPFROMP(pszLine) );
      WinSetDlgItemText( hwnd, ID_E_ROM_ADDRESS, szVal2 );

      for ( iNext = 2; ( pszLine = FindRomBios( iNext, szVal1, szVal2 ) ) != 0 ; iNext++ )
         {
         WinSendDlgItemMsg( hwnd, ID_DD_ROM_BIOS, LM_INSERTITEM, MPFROMLONG(LIT_END), szVal1 );
         WinSendDlgItemMsg( hwnd, ID_DD_ROM_BIOS, LM_SETITEMHANDLE, MPFROMLONG(iNext-1), MPFROMP(pszLine) );
         }
      }

   if ( ( pszLine = FindVgaBios( 1, szVal1 ) ) != 0 )
      {
      WinSendDlgItemMsg( hwnd, ID_DD_VGA_BIOS, LM_INSERTITEM, MPFROMLONG(LIT_END), szVal1 );
      WinSendDlgItemMsg( hwnd, ID_DD_VGA_BIOS, LM_SELECTITEM, MPFROMLONG(0), MPFROMLONG(TRUE) );
      WinSendDlgItemMsg( hwnd, ID_DD_VGA_BIOS, LM_SETITEMHANDLE, MPFROMLONG(0), MPFROMP(pszLine) );

      for ( iNext = 2; ( pszLine = FindVgaBios( iNext, szVal1 ) ) != 0 ; iNext++ )
         {
         WinSendDlgItemMsg( hwnd, ID_DD_VGA_BIOS, LM_INSERTITEM, MPFROMLONG(LIT_END), szVal1 );
         WinSendDlgItemMsg( hwnd, ID_DD_VGA_BIOS, LM_SETITEMHANDLE, MPFROMLONG(iNext-1), MPFROMP(pszLine) );
         }
      }

   if ( ( pszLine = FindFloppyA( 1, szVal1, szVal2 ) ) != 0 )
      {
      WinSendDlgItemMsg( hwnd, ID_DD_FLOPPYA, LM_INSERTITEM, MPFROMLONG(LIT_END), szVal1 );
      WinSendDlgItemMsg( hwnd, ID_DD_FLOPPYA, LM_SELECTITEM, MPFROMLONG(0), MPFROMLONG(TRUE) );
      WinSendDlgItemMsg( hwnd, ID_DD_FLOPPYA, LM_SETITEMHANDLE, MPFROMLONG(0), MPFROMP(pszLine) );

      if ( strcmp(szVal2, "inserted") == 0 )
         {
         WinCheckButton(hwnd, ID_CHK_FLOPPYA_INSERTED, 1 );
         }

      for ( iNext = 2; ( pszLine = FindFloppyA( iNext, szVal1, szVal2 ) ) != 0 ; iNext++ )
         {
         WinSendDlgItemMsg( hwnd, ID_DD_FLOPPYA, LM_INSERTITEM, MPFROMLONG(LIT_END), szVal1 );
         WinSendDlgItemMsg( hwnd, ID_DD_FLOPPYA, LM_SETITEMHANDLE, MPFROMLONG(iNext-1), MPFROMP(pszLine) );
         }
      }

   if ( ( pszLine = FindFloppyB( 1, szVal1, szVal2 ) ) != 0 )
      {
      WinSendDlgItemMsg( hwnd, ID_DD_FLOPPYB, LM_INSERTITEM, MPFROMLONG(LIT_END), szVal1 );
      WinSendDlgItemMsg( hwnd, ID_DD_FLOPPYB, LM_SELECTITEM, MPFROMLONG(0), MPFROMLONG(TRUE) );
      WinSendDlgItemMsg( hwnd, ID_DD_FLOPPYB, LM_SETITEMHANDLE, MPFROMLONG(0), MPFROMP(pszLine) );

      if ( strcmp(szVal2, "inserted") == 0 )
         {
         WinCheckButton(hwnd, ID_CHK_FLOPPYB_INSERTED, 1 );
         }

      for ( iNext = 2; ( pszLine = FindFloppyB( iNext, szVal1, szVal2 ) ) != 0 ; iNext++ )
         {
         WinSendDlgItemMsg( hwnd, ID_DD_FLOPPYB, LM_INSERTITEM, MPFROMLONG(LIT_END), szVal1 );
         WinSendDlgItemMsg( hwnd, ID_DD_FLOPPYB, LM_SETITEMHANDLE, MPFROMLONG(iNext-1), MPFROMP(pszLine) );
         }
      }

   if ( ( pszLine = FindDiskC( 1, szVal1, szVal2, szVal3, szVal4 ) ) != 0 )
      {
      WinSendDlgItemMsg( hwnd, ID_DD_DISKC, LM_INSERTITEM, MPFROMLONG(LIT_END), szVal1 );
      WinSendDlgItemMsg( hwnd, ID_DD_DISKC, LM_SELECTITEM, MPFROMLONG(0), MPFROMLONG(TRUE) );
      WinSendDlgItemMsg( hwnd, ID_DD_DISKC, LM_SETITEMHANDLE, MPFROMLONG(0), MPFROMP(pszLine) );

      WinSetDlgItemText( hwnd, ID_E_CYL, szVal2 );
      WinSetDlgItemText( hwnd, ID_E_HEAD, szVal3 );
      WinSetDlgItemText( hwnd, ID_E_SPT, szVal4 );

      for ( iNext = 2; ( pszLine = FindDiskC( iNext, szVal1, szVal2, szVal3, szVal4 ) ) != 0 ; iNext++ )
         {
         WinSendDlgItemMsg( hwnd, ID_DD_DISKC, LM_INSERTITEM, MPFROMLONG(LIT_END), szVal1 );
         WinSendDlgItemMsg( hwnd, ID_DD_DISKC, LM_SETITEMHANDLE, MPFROMLONG(iNext-1), MPFROMP(pszLine) );
         }
      }

   if ( ( pszLine = FindLpt1( 1, szVal1 ) ) != 0 )
      {
      WinSendDlgItemMsg( hwnd, ID_DD_LPT1, LM_INSERTITEM, MPFROMLONG(LIT_END), szVal1 );
      WinSendDlgItemMsg( hwnd, ID_DD_LPT1, LM_SELECTITEM, MPFROMLONG(0), MPFROMLONG(TRUE) );
      WinSendDlgItemMsg( hwnd, ID_DD_LPT1, LM_SETITEMHANDLE, MPFROMLONG(0), MPFROMP(pszLine) );

      for ( iNext = 2; ( pszLine = FindLpt1( iNext, szVal1 ) ) != 0 ; iNext++ )
         {
         WinSendDlgItemMsg( hwnd, ID_DD_LPT1, LM_INSERTITEM, MPFROMLONG(LIT_END), szVal1 );
         WinSendDlgItemMsg( hwnd, ID_DD_LPT1, LM_SETITEMHANDLE, MPFROMLONG(iNext-1), MPFROMP(pszLine) );
         }
      }

   if ( ( pszLine = FindLpt2( 1, szVal1 ) ) != 0 )
      {
      WinSendDlgItemMsg( hwnd, ID_DD_LPT2, LM_INSERTITEM, MPFROMLONG(LIT_END), szVal1 );
      WinSendDlgItemMsg( hwnd, ID_DD_LPT2, LM_SELECTITEM, MPFROMLONG(0), MPFROMLONG(TRUE) );
      WinSendDlgItemMsg( hwnd, ID_DD_LPT2, LM_SETITEMHANDLE, MPFROMLONG(0), MPFROMP(pszLine) );

      for ( iNext = 2; ( pszLine = FindLpt2( iNext, szVal1 ) ) != 0 ; iNext++ )
         {
         WinSendDlgItemMsg( hwnd, ID_DD_LPT2, LM_INSERTITEM, MPFROMLONG(LIT_END), szVal1 );
         WinSendDlgItemMsg( hwnd, ID_DD_LPT2, LM_SETITEMHANDLE, MPFROMLONG(iNext-1), MPFROMP(pszLine) );
         }
      }

   if ( ( pszLine = FindLpt3( 1, szVal1 ) ) != 0 )
      {
      WinSendDlgItemMsg( hwnd, ID_DD_LPT3, LM_INSERTITEM, MPFROMLONG(LIT_END), szVal1 );
      WinSendDlgItemMsg( hwnd, ID_DD_LPT3, LM_SELECTITEM, MPFROMLONG(0), MPFROMLONG(TRUE) );
      WinSendDlgItemMsg( hwnd, ID_DD_LPT3, LM_SETITEMHANDLE, MPFROMLONG(0), MPFROMP(pszLine) );

      for ( iNext = 2; ( pszLine = FindLpt3( iNext, szVal1 ) ) != 0 ; iNext++ )
         {
         WinSendDlgItemMsg( hwnd, ID_DD_LPT3, LM_INSERTITEM, MPFROMLONG(LIT_END), szVal1 );
         WinSendDlgItemMsg( hwnd, ID_DD_LPT3, LM_SETITEMHANDLE, MPFROMLONG(iNext-1), MPFROMP(pszLine) );
         }
      }

   /* Log File Name - default is ./bochs.out */
   pszLine = FindLog( 1, szVal1 );
   if ( !pszLine )
      {
      strcpy( BochsRC[iBochsRCLastLine], "log: ./bochs.out" );
      iBochsRCLastLine++;
      pszLine = FindLog( 1, szVal1 );
      }
   WinSetDlgItemText( hwnd, ID_E_LOGFILE, szVal1 );

   /* Memory Size - default is 1 Megabyte */
   pszLine = FindMem( 1, szVal1 );
   if ( !pszLine )
      {
      strcpy( BochsRC[iBochsRCLastLine], "megs: 1" );
      iBochsRCLastLine++;
      pszLine = FindMem( 1, szVal1 );
      }
   WinSetDlgItemText( hwnd, ID_E_MEM, szVal1 );

   /* Instructions Per Second - default is 500000 */
   pszLine = FindIps( 1, szVal1 );
   if ( !pszLine )
      {
      strcpy( BochsRC[iBochsRCLastLine], "ips: 500000" );
      iBochsRCLastLine++;
      pszLine = FindIps( 1, szVal1 );
      }
   WinSetDlgItemText( hwnd, ID_E_IPS, szVal1 );

   /* Floppy Command Delay - default is 500 */
   pszLine = FindFcd( 1, szVal1 );
   if ( !pszLine )
      {
      strcpy( BochsRC[iBochsRCLastLine], "floppy_command_delay: 500" );
      iBochsRCLastLine++;
      pszLine = FindFcd( 1, szVal1 );
      }
   WinSetDlgItemText( hwnd, ID_E_FCD, szVal1 );

   /* Keyboard Serial Delay - default is 200 */
   pszLine = FindKsd( 1, szVal1 );
   if ( !pszLine )
      {
      strcpy( BochsRC[iBochsRCLastLine], "keyboard_serial_delay: 200" );
      iBochsRCLastLine++;
      pszLine = FindKsd( 1, szVal1 );
      }
   WinSetDlgItemText( hwnd, ID_E_KSD, szVal1 );

   /* Video Update Interval - default is 300000 */
   pszLine = FindVui( 1, szVal1 );
   if ( !pszLine )
      {
      strcpy( BochsRC[iBochsRCLastLine], "vga_update_interval: 300000" );
      iBochsRCLastLine++;
      pszLine = FindVui( 1, szVal1 );
      }
   WinSetDlgItemText( hwnd, ID_E_VGAUI, szVal1 );

   /* Video Mode - default is emulated */
   pszLine = FindVideoMode( 1, szVal1 );
   if ( !pszLine )
      {
      strcpy( BochsRC[iBochsRCLastLine], "videomode: emulated" );
      iBochsRCLastLine++;
      pszLine = FindVideoMode( 1, szVal1 );
      }
   WinCheckButton(hwnd, ID_CHK_DVA, ( strcmp(szVal1,"direct") == 0 ) ? 1 : 0 );

   pszLine = FindBoot( 1, szVal1 );

   if ( !pszLine )
      {
      strcpy( BochsRC[iBochsRCLastLine], "boot: a" );
      iBochsRCLastLine++;
      pszLine = FindBoot( 1, szVal1 );
      }
   if ( szVal1[0] == 'c' )
      {
      WinCheckButton(hwnd, ID_CHK_BOOT_FLOPPY, 0 );
      WinCheckButton(hwnd, ID_CHK_BOOT_HARDDRIVE, 1 );
      }
   else
      {
      WinCheckButton(hwnd, ID_CHK_BOOT_HARDDRIVE, 0 );
      WinCheckButton(hwnd, ID_CHK_BOOT_FLOPPY, 1 );
      }

   fWritingControls = 0 ;
}

VOID ReadControls( HWND hwnd )
{
   char *pszLine;
   char szVal1[256];

   pszLine = FindVideoMode( 1, szVal1 );
   UpdateVideoMode( pszLine, WinQueryButtonCheckstate(hwnd,ID_CHK_DVA) ? "direct" : "emulated" );

   pszLine = FindLog( 1, szVal1 );
   WinQueryDlgItemText( hwnd, ID_E_LOGFILE,sizeof(szVal1), szVal1 );
   UpdateLog( pszLine, szVal1 );

   pszLine = FindMem( 1, szVal1 );
   WinQueryDlgItemText( hwnd, ID_E_MEM,sizeof(szVal1), szVal1 );
   UpdateMem( pszLine, szVal1 );

   pszLine = FindIps( 1, szVal1 );
   WinQueryDlgItemText( hwnd, ID_E_IPS,sizeof(szVal1), szVal1 );
   UpdateIps( pszLine, szVal1 );

   pszLine = FindFcd( 1, szVal1 );
   WinQueryDlgItemText( hwnd, ID_E_FCD,sizeof(szVal1), szVal1 );
   UpdateFcd( pszLine, szVal1 );

   pszLine = FindKsd( 1, szVal1 );
   WinQueryDlgItemText( hwnd, ID_E_KSD,sizeof(szVal1), szVal1 );
   UpdateKsd( pszLine, szVal1 );

   pszLine = FindVui( 1, szVal1 );
   WinQueryDlgItemText( hwnd, ID_E_VGAUI,sizeof(szVal1), szVal1 );
   UpdateVui( pszLine, szVal1 );

   pszLine = FindBoot( 1, szVal1 );
   UpdateBoot( pszLine, WinQueryButtonCheckstate(hwnd, ID_CHK_BOOT_FLOPPY) ? "a" : "c" );
}

char szAddVal[256];

MRESULT EXPENTRY AddDlg( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
   switch ( msg )
   {
      case WM_INITDLG:
         WinSetFocus( HWND_DESKTOP, WinQueryWindow(hwnd, ID_E_NEW) );
         break;

      case WM_COMMAND:
         if ( LONGFROMMP(mp1) == ID_PB_FIND )
            {
            FILEDLG FileDlg = {0};
            int i;

            FileDlg.cbSize = sizeof(FILEDLG);
            FileDlg.fl = FDS_OPEN_DIALOG | FDS_CENTER ;
            FileDlg.pszTitle = (PSZ) "Find Existing File";
            FileDlg.pszOKButton = (PSZ) "Add";
            WinFileDlg( HWND_DESKTOP, hwnd, &FileDlg );
            if ( FileDlg.lReturn != DID_OK )
               break;
            strcpy(szAddVal, FileDlg.szFullFile);
            for ( i = 0 ; i < strlen(szAddVal) ; i++ )
               if ( szAddVal[i] == '\\' )
                  szAddVal[i] = '/';
            WinDismissDlg( hwnd, 0 );
            WinDestroyWindow( hwnd );
            }
         else
            {
            memset( szAddVal, 0, sizeof(szAddVal) );
            if ( LONGFROMMP(mp1) == ID_PB_SAVE )
               WinQueryDlgItemText( hwnd, ID_E_NEW, sizeof(szAddVal), szAddVal );
            WinDismissDlg( hwnd, 0 );
            WinDestroyWindow( hwnd );
            }
         break;

      default: 
         return WinDefDlgProc( hwnd, msg, mp1, mp2 );
   }

   return (MRESULT)FALSE;
}

MRESULT EXPENTRY ConfigureDlg( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
   char szBuffer[256];
   char szVal1[256];
   char szVal2[256];
   char szVal3[256];
   char szVal4[256];
   USHORT usID, usType;
   HWND hControl;
   char *pszNew, *pszLine;
   ULONG ulNew, ulCount, ulI;


   switch ( msg )
   {
      case WM_INITDLG:
         if ( RCRead() == 0 )
            {
            WinMessageBox( HWND_DESKTOP, hwnd, "Error while trying to read configuration file.", "Bochs Configuration Manager", ID_MSGBOX_ERR, MB_MOVEABLE | MB_CUACRITICAL | MB_CANCEL );
            WinDismissDlg( hwnd, 0 );
            WinDestroyWindow( hwnd );
            }
         WriteControls( hwnd );
         break;

      case WM_CONTROL:
         usID = SHORT1FROMMP(mp1);
         usType = SHORT2FROMMP(mp1);
         hControl = (HWND)mp2;

         switch ( usID )
            {
            case ID_CHK_FLOPPYA_INSERTED:
               if ( usType == BN_CLICKED && !fWritingControls )
                  {
                  pszLine = FindFloppyA( 1, szVal1, szVal2 );
                  if ( pszLine )
                     {
                     UpdateFloppyA( pszLine, szVal1, WinQueryButtonCheckstate(hwnd, usID) ? "inserted" : "ejected" );
                     }
                  }
               break;

            case ID_CHK_FLOPPYB_INSERTED:
               if ( usType == BN_CLICKED && !fWritingControls )
                  {
                  pszLine = FindFloppyB( 1, szVal1, szVal2 );
                  if ( pszLine )
                     {
                     UpdateFloppyB( pszLine, szVal1, WinQueryButtonCheckstate(hwnd, usID) ? "inserted" : "ejected" );
                     }
                  }
               break;

            case ID_E_CYL:
               if ( usType == EN_CHANGE && !fWritingControls )
                  {
                  pszLine = FindDiskC( 1, szVal1, szVal2, szVal3, szVal4 );
                  WinQueryWindowText( hControl, sizeof(szVal2), szVal2 );
                  UpdateDiskC( pszLine, szVal1, szVal2, szVal3, szVal4 );
                  }
               break;

            case ID_E_HEAD:
               if ( usType == EN_CHANGE && !fWritingControls )
                  {
                  pszLine = FindDiskC( 1, szVal1, szVal2, szVal3, szVal4 );
                  WinQueryWindowText( hControl, sizeof(szVal3), szVal3 );
                  UpdateDiskC( pszLine, szVal1, szVal2, szVal3, szVal4 );
                  }
               break;

            case ID_E_SPT:
               if ( usType == EN_CHANGE && !fWritingControls )
                  {
                  pszLine = FindDiskC( 1, szVal1, szVal2, szVal3, szVal4 );
                  WinQueryWindowText( hControl, sizeof(szVal4), szVal4 );
                  UpdateDiskC( pszLine, szVal1, szVal2, szVal3, szVal4 );
                  }
               break;

            case ID_DD_ROM_BIOS:
            case ID_DD_VGA_BIOS:
            case ID_DD_FLOPPYA:
            case ID_DD_FLOPPYB:
            case ID_DD_DISKC:
            case ID_DD_LPT1:
            case ID_DD_LPT2:
            case ID_DD_LPT3:
               if ( usType == CBN_LBSELECT && !fWritingControls )
                  {
                  ulCount = (ULONG) WinSendMsg( hControl, LM_QUERYITEMCOUNT, MPFROMLONG(0), MPFROMP(0) );

                  for ( ulI = 0 ; ulI < ulCount ; ulI++ )
                     {
                     pszLine = WinSendMsg( hControl, LM_QUERYITEMHANDLE, MPFROMLONG(ulI), MPFROMP(0) );
                     if ( pszLine[0] != '#' )
                        {
                        strcpy( szBuffer, "#" );
                        strcat( szBuffer, pszLine );
                        strcpy( pszLine, szBuffer );
                        }
                     }

                  ulNew = (ULONG) WinSendMsg( hControl, LM_QUERYSELECTION, MPFROMLONG(LIT_FIRST), MPFROMP(0) );

                  pszNew = WinSendMsg( hControl, LM_QUERYITEMHANDLE, MPFROMLONG(ulNew), MPFROMP(0) );
                  strcpy( szBuffer, pszNew + 1 );
                  strcpy( pszNew, szBuffer );

                  switch ( usID )
                     {
                     case ID_DD_ROM_BIOS:
                        pszLine = FindRomBios( 1, szVal1, szVal2 );
                        WinSetDlgItemText( hwnd, ID_E_ROM_ADDRESS, szVal2 );
                        break;
                     case ID_DD_FLOPPYA:
                        pszLine = FindFloppyA( 1, szVal1, szVal2 );
                        WinCheckButton(hwnd, ID_CHK_FLOPPYA_INSERTED, ( strcmp(szVal2, "inserted") == 0 ) ? 1 : 0 );
                        break;
                     case ID_DD_FLOPPYB:
                        pszLine = FindFloppyB( 1, szVal1, szVal2 );
                        WinCheckButton(hwnd, ID_CHK_FLOPPYB_INSERTED, ( strcmp(szVal2, "inserted") == 0 ) ? 1 : 0 );
                        break;
                     case ID_DD_DISKC:
                        pszLine = FindDiskC( 1, szVal1, szVal2, szVal3, szVal4 );
                        WinSetDlgItemText( hwnd, ID_E_CYL, szVal2 );
                        WinSetDlgItemText( hwnd, ID_E_HEAD, szVal3 );
                        WinSetDlgItemText( hwnd, ID_E_SPT, szVal4 );
                        break;
                     }
                  }
               break;
            }
         break;

      case WM_COMMAND:
         usID = SHORT1FROMMP(mp1);

         switch ( usID )
            {
            case ID_PB_ADD_ROM_BIOS:
            case ID_PB_ADD_VGA_BIOS:
            case ID_PB_ADD_FLOPPYA:
            case ID_PB_ADD_FLOPPYB:
            case ID_PB_ADD_DISKC:
            case ID_PB_ADD_LPT1:
            case ID_PB_ADD_LPT2:
            case ID_PB_ADD_LPT3:
               WinDlgBox( HWND_DESKTOP, hwnd, AddDlg, 0, ID_DLG_ADD, 0 );

               if ( strlen(szAddVal) == 0 )
                  break;

               strcpy( szVal1, szAddVal );
               pszLine = BochsRC[iBochsRCLastLine];
               iBochsRCLastLine++;

               switch ( usID )
                  {
                  case ID_PB_ADD_ROM_BIOS:
                     WinQueryDlgItemText( hwnd, ID_E_ROM_ADDRESS, sizeof(szVal2), szVal2 );
                     UpdateRomBios( pszLine, szVal1, szVal2 );
                     hControl = WinWindowFromID( hwnd, ID_DD_ROM_BIOS );
                     break;
                  case ID_PB_ADD_VGA_BIOS:
                     UpdateVgaBios( pszLine, szVal1 );
                     hControl = WinWindowFromID( hwnd, ID_DD_VGA_BIOS );
                     break;
                  case ID_PB_ADD_FLOPPYA:
                     UpdateFloppyA( pszLine, szVal1, WinQueryButtonCheckstate(hwnd, ID_CHK_FLOPPYA_INSERTED) ? "inserted" : "ejected" );
                     hControl = WinWindowFromID( hwnd, ID_DD_FLOPPYA );
                     break;
                  case ID_PB_ADD_FLOPPYB:
                     UpdateFloppyA( pszLine, szVal1, WinQueryButtonCheckstate(hwnd, ID_CHK_FLOPPYB_INSERTED) ? "inserted" : "ejected" );
                     hControl = WinWindowFromID( hwnd, ID_DD_FLOPPYB );
                     break;
                  case ID_PB_ADD_DISKC:
                     WinQueryDlgItemText( hwnd, ID_E_CYL, sizeof(szVal2), szVal2 );
                     WinQueryDlgItemText( hwnd, ID_E_HEAD, sizeof(szVal3), szVal3 );
                     WinQueryDlgItemText( hwnd, ID_E_SPT, sizeof(szVal4), szVal4 );
                     UpdateDiskC( pszLine, szVal1, szVal2, szVal3, szVal4 );
                     hControl = WinWindowFromID( hwnd, ID_DD_DISKC );
                     break;
                  case ID_PB_ADD_LPT1:
                     UpdateLpt1( pszLine, szVal1 );
                     hControl = WinWindowFromID( hwnd, ID_DD_LPT1 );
                     break;
                  case ID_PB_ADD_LPT2:
                     UpdateLpt1( pszLine, szVal2 );
                     hControl = WinWindowFromID( hwnd, ID_DD_LPT2 );
                     break;
                  case ID_PB_ADD_LPT3:
                     UpdateLpt1( pszLine, szVal3 );
                     hControl = WinWindowFromID( hwnd, ID_DD_LPT3 );
                     break;
                  }

               ulNew = (ULONG) WinSendMsg( hControl, LM_INSERTITEM, MPFROMLONG(LIT_END), szVal1 );
               WinSendMsg( hControl, LM_SETITEMHANDLE, MPFROMLONG(ulNew), MPFROMP(pszLine) );
               WinSendMsg( hControl, LM_SELECTITEM, MPFROMLONG(ulNew), MPFROMLONG(1) );
               break;
            case ID_PB_SAVE:
               ReadControls( hwnd );
               RCSave();
            default:
               WinDismissDlg( hwnd, 0 );
               WinDestroyWindow( hwnd );
               break;
            }
         break;

      default: 
         return WinDefDlgProc( hwnd, msg, mp1, mp2 );
   }

   return (MRESULT)FALSE;
}


MRESULT EXPENTRY LaunchDlg( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
   char szVal[256];

   switch ( msg )
   {
      case WM_INITDLG:
         WinCheckButton(hwnd, ID_CHK_LAUNCH_FS, 0 );
         WinCheckButton(hwnd, ID_CHK_LAUNCH_WIN, 1 );
         WinSetFocus( HWND_DESKTOP, WinQueryWindow(hwnd, ID_PB_LAUNCH) );
         break;

      case WM_COMMAND:
         switch ( LONGFROMMP(mp1) )
            {
            case ID_PB_CONFIGURE :
               WinDlgBox( HWND_DESKTOP, hwnd, ConfigureDlg, 0, ID_DLG_CONFIGURE, NULL );
               break;
            case ID_PB_LAUNCH :
               {
               PROGDETAILS pd = {0};

               pd.Length          = sizeof(pd);
               pd.progt.progc     = WinQueryButtonCheckstate(hwnd, ID_CHK_LAUNCH_FS) ? PROG_FULLSCREEN : PROG_PM;
               pd.progt.fbVisible = SHE_VISIBLE;
               pd.pszTitle        = "Bochs/2";
               pd.pszExecutable   = "bochs2.exe";
               pd.swpInitial.fl   = SWP_ACTIVATE;
               pd.swpInitial.hwndInsertBehind = HWND_TOP;
               pd.swpInitial.hwnd = HWND_DESKTOP;

               WinStartApp( hwnd, &pd, 0, 0, SAF_STARTCHILDAPP );
               }
               break;
            default:
               WinDismissDlg( hwnd, 0 );
               WinDestroyWindow( hwnd );
               break;
            }
         break;

      default: 
         return WinDefDlgProc( hwnd, msg, mp1, mp2 );
   }

   return (MRESULT)FALSE;
}


MRESULT EXPENTRY MainWindowProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
   switch( msg )
   {
      case WM_CREATE:
         WinDlgBox( HWND_DESKTOP, hwnd, LaunchDlg, 0, ID_DLG_COMMANDER, NULL );
         WinPostMsg( hwnd, WM_QUIT, 0, 0 );
         break;

      default: 
         return WinDefWindowProc( hwnd, msg, mp1, mp2 );
   }

   return (MRESULT)FALSE;
}

INT main (VOID)
{
   HMQ  hmq;                             /* Message queue handle         */
   HWND hwndClient = NULLHANDLE;         /* Client area window handle    */
   HWND hwndFrame = NULLHANDLE;          /* Frame window handle          */
   QMSG qmsg;                            /* Message from message queue   */
   ULONG flCreate;                       /* Window creation control flags*/

   hab = WinInitialize(0);
   hmq = WinCreateMsgQueue( hab, 0 );
   WinRegisterClass( hab, (PSZ)"BochsLaunchConfigure", (PFNWP)MainWindowProc, 0, 0 );
   flCreate = FCF_TITLEBAR | FCF_SYSMENU | FCF_MINBUTTON | FCF_MAXBUTTON | FCF_SIZEBORDER | FCF_TASKLIST;
   hwndFrame = WinCreateStdWindow( HWND_DESKTOP, 0, &flCreate, "BochsLaunchConfigure", "", 0, (HMODULE)0L, ID_WIN_MAIN, &hwndClient );
   WinSetWindowPos( hwndFrame, HWND_TOP, 100, 100, 2, 2, SWP_SIZE | SWP_MOVE | SWP_ACTIVATE | SWP_SHOW );

   while( WinGetMsg( hab, &qmsg, 0L, 0, 0 ) )
      WinDispatchMsg( hab, &qmsg );

   WinDestroyWindow(hwndFrame);
   WinDestroyMsgQueue( hmq );
   WinTerminate( hab );
   return(0);
}

