/*$Id: kaleido.h,v 3.15 1996/03/10 12:35:18 rl Rel $*/
/**********************************************************
* kaleido
*
*	Kaleidoscopic construction of uniform polyhedra
*	Copyright (C) 1991-1996 Dr. Zvi Har'El <rl@math.technion.ac.il>
*
*	This program is free software; you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation; either version 2 of the License, or
*	(at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*	Author:
*		Dr. Zvi Har'El,
*		Technion, Israel Institue of Technology,
*		Haifa 32000, Israel.
*		E-Mail: rl@math.technion.ac.il
**********************************************************/
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <math.h>
#ifdef __STDC__
#include <stdlib.h>
#endif


#ifndef MAXLONG
#define MAXLONG 0x7FFFFFFF
#endif
#ifndef MAXDIGITS
#define MAXDIGITS 10 /* (int)log10((double)MAXLONG) + 1 */
#endif
#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif
#ifndef DBL_EPSILON
#define DBL_EPSILON 2.2204460492503131e-16
#endif
#define BIG_EPSILON 3e-2
#define DEG (180/M_PI)
#define AZ M_PI/7 /* axis azimuth */
#define EL M_PI/17 /* axis elevation */

#define VAL (argp=s[1]?s+1:(argc--,*++argv),s="-",!argp?( char *)usage():argp)
#define Err(x) {error.message=x;error.line=__LINE__;error.file=__FILE__; return 0;}
#define Free(lvalue) {if(lvalue){free((char*)lvalue); lvalue=0;}}
#define Matfree(lvalue,n) {if(lvalue)matfree((char*)lvalue,n);lvalue=0;}
#define Malloc(lvalue,n,type) {if(!(lvalue=(type*)malloc((n)*sizeof(type))))Err(0)}
#define Realloc(lvalue,n,type) {if(!(lvalue=(type*)realloc(lvalue,(n)*sizeof(type))))Err(0)}
#define Calloc(lvalue,n,type) {if(!(lvalue=(type*)calloc(n,sizeof(type))))Err(0)}
#define Matalloc(lvalue,n,m,type) {if(!(lvalue=(type**)matalloc(n,(m)*sizeof(type))))Err(0)}
#define Sprintfrac(lvalue,x) {if(!(lvalue=sprintfrac(x)))return 0;}
#define numerator(x) (frac(x),frax.n)
#define denominator(x) (frac(x),frax.d)
#define compl(x) (frac(x),(double)frax.n/(frax.n-frax.d))

typedef struct {double x,y,z;} Vector;

typedef struct {
	/* NOTE: some of the int's can be replaced by short's, char's,
	or even bit fields, at the expense of readability!!!*/
	int index; /* index to the standard list, the array uniform[] */
	int N; /* number of faces types (atmost 5) */
	int M; /* vertex valency (may be big for dihedral polyhedra) */
	int V; /* vertex count */
	int E; /* edge count */
	int F; /* face count */
	int D; /* density */
	int chi; /* Euler characteristic */
	int g; /* order of symmetry group */
	int K; /* symmetry type: D=2, T=3, O=4, I=5 */
	int hemi;/* flag hemi polyhedron */
	int onesided;/* flag onesided polyhedron */
	int even; /* removed face in pqr| */
	int *Fi; /* face counts by type (array N) */
	int *rot; /* vertex configuration (array M of 0..N-1) */
	int *snub; /* snub triangle configuration (array M of 0..1) */
	int *firstrot; /* temporary for vertex generation (array V) */
	int *anti; /* temporary for direction of ideal vertices (array E) */
	int *ftype; /* face types (array F) */
	int **e; /* edges (matrix 2 x E of 0..V-1) */
	int **dual_e; /* dual edges (matrix 2 x E of 0..F-1) */
	int **incid; /* vertex-face incidence (matrix M x V of 0..F-1) */
	int **adj; /* vertex-vertex adjacency (matrix M x V of 0..V-1) */
	double p[4]; /* p, q and r; |=0 */
	double minr; /* smallest nonzero inradius */
	double gon; /* basis type for dihedral polyhedra */
	double *n; /* number of side of a face of each type (array N) */
	double *m; /* number of faces at a vertex of each type (array N) */
	double *gamma; /* fundamental angles in radians (array N) */
	char *polyform; /* printable Wythoff symbol */
	char *config; /* printable vertex configuration */
	char *name; /* name, standard or manifuctured */
	char *dual_name; /* dual name, standard or manifuctured */
	Vector *v; /* vertex coordinates (array V) */
	Vector *f; /* face coordinates (array F) */
} Polyhedron;

typedef struct { /* See uniform.h for explanation of the fields */
	char *Wythoff, *name, *dual;
	short Coxeter, Wenninger;
} Uniform;

typedef struct {long n,d;} Fraction;

typedef struct {char *message; int line; char *file;} Error;

extern Polyhedron *kaleido(), *polyalloc();
extern Vector rotate(), sum3(), scale(), sum(), diff(), pole();
extern double dot();
extern char *picfile(), *sprintfrac(), *nextsym(), **matalloc();
extern void frac();

extern Uniform uniform[];
extern Fraction frax;
extern Error error;
extern last_uniform, gcont;

#ifndef __STDC__
extern char *malloc(), *realloc(), *getenv();
#endif

#ifndef __EMX__
extern char *sys_errlist[];
#endif
extern errno, sys_nerr;
