/* Datei: less.h
** angegelegt am 1/13/1998
**
** prototypes and includes for less.c
**
** RCS: $Id: less.h.# 0.2 1998/03/07 19:44:14 CBENDEN Exp $
**
**  less - an a simple pager for OS/2
**  Copyright (C) 1998  Clemens Maria Benden   (cbenden@netproject.de)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**       You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
**  ---------------- Datei-Log ---------------------
**  $Log: less.h.# $
**Revision 0.2  1998/03/07  19:44:14  CBENDEN
**- Build Version 0.2
**
**Revision 0.1  1998/02/04  12:55:46  CBENDEN
**initial checkin
**
**  -------------- Datei-Log Ende ------------------
*/

#ifndef   LESS_H

   #define LESS_H

   /* *** LOCAL DEFINES *** */

   /* *** INCLUDES *** */

      #include    "..\include\defines.def"

      #include    <fcntl.h>
      #include    <io.h>
      #include    <signal.h>
      #include    <share.h>
      #include    <stdarg.h>
      #include    <stdio.h>
      #include    <stdlib.h>
      #include    <string.h>
      #include    <sys\stat.h>

      #include    "..\include\lessinit.h"
      #include    "..\include\lesssem.h"
      #include    "..\include\lessvio.h"

   /* *** PROTOTYPES *** */

   int                     colorLine( int row, line *linePtr );
   int                     moveDOWN( void );
   int                     moveEND( void );
   int                     moveHOME( void );
   int                     movePGDN( void );
   int                     movePGUP( void );
   int                     moveUP(void );
   char *                  msg(int msgId, ...);
   char *                  msg_crlf(int msgId, ...);
   int                     nextchar( int handle );
   char *                  readline( char *buffer, int buffersize, int *bytesReaded, int handle );
   void                    readThread( void *threadArgs );
   void                    searchThread(void *searchArgs);
   void                    showHelp(void);
   void                    showPage(void);
   void                    updateStatus(void);
   void                    viewLoop(void);

#endif

