/* Datei: less.c
** angegelegt am 1/13/1998
**
** main routines and threads
**
** RCS: $Id: less.c.# 0.2 1998/03/07 19:45:32 CBENDEN Exp $
**
**  less - an a simple pager for OS/2
**  Copyright (C) 1998  Clemens Maria Benden   (cbenden@netproject.de)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**       You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
**  ---------------- Datei-Log ---------------------
**  $Log: less.c.# $
**Revision 0.2  1998/03/07  19:45:32  CBENDEN
**- Build Version 0.2
**
**Revision 0.1  1998/02/04  12:57:12  CBENDEN
**initial checkin
**
**  -------------- Datei-Log Ende ------------------
*/

/*  *** Local Defines *** *** */

/*  *** Includes *** *** */

   #include    "..\include\less.h"

/*  *** Globals / Statics *** *** */

   globalData              gbl;
   static int              sigNested;

/*  *** Externals *** *** */

/*  exitHandler
** Bemerkung
** Handling of OS/2 signals
**
** Parameter
** sigId                   ID of signal
**
** Return
**
**  */

void                       exitHandler(int sigId)

{  APIRET                  rc;
   int                     normalExit=0;
   win                     *excpInfo=NULL;

   switch ( sigId )
      {
      case  SIGABRT:                   /* *** Abort *** */

                                       excpInfo = message( msg(MSG_LESS_EXCPT_ABORT, NULL) );
                                       #ifndef RELEASE
                                          writeStr( 50, BOTTOM, "SIG:ABORT!" );
                                       #endif
                                       break;

      case  SIGFPE:                    /* *** Floatingpoint Error *** */

                                       excpInfo = message( msg(MSG_LESS_EXCPT_FPE, NULL) );
                                       #ifndef RELEASE
                                          writeStr( 50, BOTTOM, "SIG:FPERR!" );
                                       #endif
                                       break;

      case  SIGILL:                    /* *** Illegal Instruction *** */

                                       excpInfo = message( msg(MSG_LESS_EXCPT_ILL, NULL) );
                                       #ifndef RELEASE
                                          writeStr( 50, BOTTOM, "SIG:ILL!  " );
                                       #endif
                                       break;

      case  SIGSEGV:                   /* *** Segment Violation *** */

                                       excpInfo = message( msg(MSG_LESS_EXCPT_SEGV, NULL) );
                                       #ifndef RELEASE
                                          writeStr( 50, BOTTOM, "SIG:SEGV! " );
                                       #endif
                                       break;

      case  SIGTERM:                   /* *** external Termination *** */

                                       excpInfo = message( msg(MSG_LESS_EXCPT_TERM, NULL) );
                                       #ifndef RELEASE
                                          writeStr( 50, BOTTOM, "SIG:TERM! " );
                                       #endif
                                       break;

      case  SIGBREAK:                  /* *** Ctrl+Break *** */

                                       excpInfo = message( msg(MSG_LESS_EXCPT_BREAK, NULL) );
                                       #ifndef RELEASE
                                          writeStr( 50, BOTTOM, "SIG:BREAK!" );
                                       #endif
                                       normalExit=1;
                                       break;

      case  SIGINT:                    /* *** Ctrl+C *** */

                                       excpInfo = message( msg(MSG_LESS_EXCPT_INT, NULL) );
                                       #ifndef RELEASE
                                          writeStr( 50, BOTTOM, "SIG:INT!  " );
                                       #endif
                                       normalExit=1;
                                       break;
      }

   if ( excpInfo )
      {  int               t;
         KBDKEYINFO        key;

      for (t=0; t<10; t++)
         {
         rc = KbdCharIn( &key, IO_NOWAIT, 0 );
         if (key.fbStatus)
            break;
         DosSleep( 100 );
         }
      closeWindow( excpInfo );
      }

   if ( !sigNested )
      {

      sigNested = 1;

      switch ( sigId )
         {
         case  SIGABRT:                   /* *** Abort *** */

                                          abort();


         case  SIGFPE:                    /* *** Floatingpoint Error *** */

                                          break;

         case  SIGILL:                    /* *** Illegal Instruction *** */

                                          break;

         case  SIGSEGV:                   /* *** Segment Violation *** */

                                          break;

         case  SIGTERM:                   /* *** external Termination *** */

                                          break;

         case  SIGBREAK:                  /* *** Ctrl+Break *** */

                                          if (!gbl.isExiting)
                                             exit(1);
                                          else
                                             abort();

                                          break;

         case  SIGINT:                    /* *** Ctrl+C *** */

                                          if (!gbl.isExiting)
                                             exit(1);
                                          else
                                             abort();
                                          break;
         }
      }
   else
      {  win         *panic;
         char        tempNum[16];
      /*
      ** Nested Signal!
      */

      sprintf( tempNum, "%d", sigId );
      panic = message( msg(MSG_LESS_NESTED_EXCEPTION, tempNum, NULL) );
      }
}

/*  */


/*  nextchar
** Bemerkung
**
**
**
**
** Parameter
**
**
** Return
**
**  */

int                         nextchar( int handle )

{  int                     bytesReaded=0, zeichen=-1;

   if ( gbl.fileEmptyBuffer )
      {

      if ( !gbl.buffer && gbl.bufferSize )
         gbl.buffer = malloc( gbl.bufferSize );

      if ( gbl.buffer )
         {

         memset( gbl.buffer, 0, gbl.bufferSize );
         bytesReaded = read( handle, gbl.buffer, gbl.bufferSize - 1);

         gbl.fileEmptyBuffer = 0;
         gbl.bufferPtr       = gbl.buffer;
         gbl.inBuffer        = bytesReaded;

         }
      }

   if ( gbl.buffer )
      {
      if ( gbl.inBuffer > 0 )
         {
         bytesReaded = 1;
         zeichen = *gbl.bufferPtr++;
         if ( (gbl.bufferPtr - gbl.buffer ) > gbl.inBuffer - 1 )
            gbl.fileEmptyBuffer=1;
         }
      }
   else
      {  char           character;

      bytesReaded = read( handle, &character, sizeof(character) );
      zeichen = character;
      }

   if ( bytesReaded < 0 )
      {
      gbl.fileError=1;
      return -1;
      }

   if ( bytesReaded == 0 )
      gbl.fileEOF=1;

   if ( gbl.fileEOF )
      return -2;

   return zeichen;

}

/*  */


/*  readline
** Bemerkung
**
**
**
**
** Parameter
**
**
** Return
**
**  */

char *                     readline( char *buffer, int buffersize, int *bytesReaded, int handle )

{  char                    *bufPtr;
   int                     character, crlf=0;

   memset( buffer, 0, buffersize );
   bufPtr = buffer;

   *bytesReaded = 0;

   do
      {
      character = nextchar( handle );
      if ( gbl.fileEOF )
         {

         if ( !*bytesReaded )
            return NULL;

         return buffer;
         }

      if ( gbl.fileError )
         return NULL;

      if ( !gbl.cli_binary )
         {
         if (character == 10)
            crlf=2;
         }

      *bufPtr++ = character;
      (*bytesReaded)++;

      }
   while ( ( *bytesReaded < (buffersize-1) ) && (crlf<2) );

   *bufPtr=0;

   return buffer;
}

/*  */


/*  readThread
** Bemerkung
** read the waiting data and put them into
** the internal list
**
** Parameter
** threadArg               thread parameter
**
** Return
**
**  */

void                       readThread(void *threadArg)

{  char                    lineBuffer[ LINE_BUFFER ];
   int                     handle;
   int                     length, maxLines;
   line                    *newRow, *lastRow;
   readThreadData          *argPtr;

   /*
   ** register signal handler
   ** (handlers working on per threads basis!)
   */

   signal( SIGINT,   (_SigFunc) exitHandler);
   signal( SIGBREAK, (_SigFunc) exitHandler);
   signal( SIGABRT,  (_SigFunc) exitHandler);
   signal( SIGTERM,  (_SigFunc) exitHandler);
   signal( SIGSEGV,  (_SigFunc) exitHandler);

   argPtr = (readThreadData *) threadArg;

   writeStr( 0,BOTTOM, msg(MSG_LESS_READING_INPUT, NULL) );

   lastRow  = NULL;
   maxLines = 0;

   handle = fileno(stdin);
   if ( gbl.cli_filename[0] )
      {  int      openmode, sharemode;

      /* NOT ANSI-C */
         {

         if ( gbl.cli_binary )
            openmode = O_RDONLY | O_BINARY;
         else
            openmode = O_RDONLY | O_TEXT;

         sharemode = SH_DENYNO;

         handle = _sopen( gbl.cli_filename, openmode, sharemode, 0  );
         if ( handle == -1 )
            gbl.viewLoopWin = message( msg(MSG_CANNOT_OPEN_FILE, gbl.cli_filename, NULL) );
         }

      }

   gbl.fileEmptyBuffer = 1;

   while ( argPtr->appRunning && (handle>-1) && ( readline( lineBuffer, sizeof( lineBuffer ), &length, handle ) || gbl.cli_liveUpdate) )
      {

      if ( length )
         {

         request_lineBufferSem();

         newRow = malloc( sizeof( *newRow ) );
         if ( newRow )
            {
            memset( newRow, 0, sizeof( *newRow ) );

            newRow->length = length;
            newRow->buffer = malloc(length+1);

            if (newRow->buffer)
               {
               memcpy( newRow->buffer, lineBuffer, length );
               newRow->buffer[length]=0;
               }

            if (lastRow)
               lastRow->next = newRow;
            else
               gbl.row = newRow;

            lastRow = newRow;

            gbl.totalSize += length;
            gbl.dataLines++;

            if ( gbl.maxDisp < BOTTOM )
               {
               if ( gbl.currentMode == ASCII_VIEW )
                  {
                  lineBuffer[RIGHT+1]=0;
                  writeFullStr( 0, gbl.maxDisp, lineBuffer );
                  }
               gbl.maxDisp++;
               }
            }
         release_lineBufferSem();
         *lineBuffer = 0;

         /*
         ** Update statusline in liveUpdate modus
         */

         if (gbl.cli_liveUpdate && gbl.cli_jumpEnd && ( gbl.dataLines > (maxLines + BOTTOM) ) )
            {
            maxLines = gbl.dataLines;
            moveEND();
            }

         }
      else
         if ( gbl.cli_liveUpdate )
            DosSleep( 250 );
      }

   if (lastRow)
      lastRow->next = NULL;

   if ( !argPtr->appRunning )
      {
      /*
      ** eat rest ...
      */
      while ( readline( lineBuffer, sizeof( lineBuffer ), &length, handle ) )
         ;
      }
   else
      {
      sprintf( lineBuffer, "%d", gbl.dataLines );
      writeStr( 0,BOTTOM, msg(MSG_LESS_READING_COMPLETE, lineBuffer, NULL) );
      }

   argPtr->tid = 0;

   /*
   ** unregister handler
   */

   signal( SIGINT,      SIG_DFL );
   signal( SIGBREAK,    SIG_DFL );
   signal( SIGABRT,     SIG_DFL );
   signal( SIGTERM,     SIG_DFL );
   signal( SIGSEGV,     SIG_DFL );

   if ( !request_screenSem() )
      {
      showPage();
      updateStatus();
      release_screenSem();
      }

}

/*  */


/*  search
** Bemerkung
** search the whole buffer and mark every line
** in which the searchexpression was found
** (showpage should be display those matched lines later)
**
** The regular expression search is done with the IBM regex
** package which is part of the IBM C/C++ runtime.
**
** NOT COMPLETED!
**
** Parameter
**
**
** Return
**
**  */

void                       searchThread(void *threadArg)

{  APIRET                  rc;
   char                    tempNum[16], tempString[32];
   int                     regOpt, t, proz, proz1, oldProz=0;
   searchThreadData        *argPtr;
   win                     *searchWin;


   if ( request_searchRunningSem() || gbl.isSearchRunning )
      {
      if ( !gbl.viewLoopWin )
         gbl.viewLoopWin = message( msg(MSG_LESS_SEARCH_IS_RUNNING, NULL) );
      return;
      }

   /*
   ** register signal handler
   ** (handlers working on per threads basis!)
   */

   signal( SIGINT,   (_SigFunc) exitHandler);
   signal( SIGBREAK, (_SigFunc) exitHandler);
   signal( SIGABRT,  (_SigFunc) exitHandler);
   signal( SIGTERM,  (_SigFunc) exitHandler);
   signal( SIGSEGV,  (_SigFunc) exitHandler);

   argPtr = (searchThreadData *) threadArg;
   argPtr->appRunning      = 1;
   argPtr->hits            = 0;
   argPtr->linesSearched   = 0;

   gbl.isSearchRunning = 1;
   release_searchRunningSem();

   if ( argPtr->searchPattern && !initSearch(argPtr->searchPattern, 0) )
      {  line        *linePtr=gbl.row;

      /*
      ** search against the whole buffer
      */

      while ( linePtr && argPtr->appRunning )
         {
         if ( doSearch( linePtr->buffer ) == 1 )
            {
            linePtr->isFindResult = 1;
            argPtr->hits++;
            }
         else
            linePtr->isFindResult = 0;

         argPtr->linesSearched++;

         if (gbl.dataLines)
            {
            proz1 = (gbl.dataLines / 100);
            if ( proz1 )
               proz = argPtr->linesSearched / proz1;
            else
               proz = 100;
            if ( proz > oldProz + 5 )
               {
               oldProz = proz;
               strcpy( tempString, msg( MSG_LESS_SEARCH_INFO, NULL ) );
               strtok( tempString, "\n\r" );
               sprintf( gbl.searchInfo, "%s %3d%%%%", tempString, proz );
               updateStatus();
               }
            }
         linePtr = linePtr->next;
         }
      termSearch();
      }

   strcpy( tempString, msg( MSG_LESS_HIT_INFO, NULL ) );
   strtok( tempString, "\n\r" );
   if ( argPtr->hits > 99999 )
      argPtr->hits=99999;

   showPage();
   sprintf( gbl.searchInfo, "%5d %s", argPtr->hits, tempString );
   updateStatus();

   for (t=0; t<10; t++)
      {
      if ( !(rc = request_searchRunningSem()) )
         {
         gbl.isSearchRunning = 0;
         release_searchRunningSem();
         break;
         }
      }

   if ( t>9 )
      {
      sprintf( tempNum, "%d", rc );
      if ( !gbl.viewLoopWin )
         gbl.viewLoopWin = message( msg(MSG_LESS_CANT_GET_SEARCHSEM, tempNum, NULL) );
      }

   if (argPtr->searchPattern)
      free( argPtr->searchPattern );

   /*
   ** unregister handler
   */

   signal( SIGINT,      SIG_DFL );
   signal( SIGBREAK,    SIG_DFL );
   signal( SIGABRT,     SIG_DFL );
   signal( SIGTERM,     SIG_DFL );
   signal( SIGSEGV,     SIG_DFL );

   argPtr->tid = 0;

}

/*  */


/*  msg
** Bemerkung
** retrieve a message from the msgfile and insert
** any parameter given.
** The last parameter must be always NULL!
**
** Parameter
** msgId
**
** Return
** ptr to static buffer with the msg
**  */

char *                     msg(int msgId, ...)

{  static char             msgBuffer[ 2048 ];
   APIRET                  rc;
   ULONG                   varsUsed, outputLength;
   char                    *varsTable[10], *arg;
   va_list                 argPtr;

   outputLength = 0;
   varsUsed     = 0;

   memset( &varsTable, 0, sizeof( varsTable ) );
   memset( msgBuffer, 0, sizeof( msgBuffer ) );

   va_start( argPtr , msgId );

   while ( (arg = va_arg(argPtr, char * )) && varsUsed < 9 )
      varsTable[ varsUsed++ ] = arg;

   va_end( argPtr );

   rc = DosGetMessage( varsTable,
                       varsUsed,
                       msgBuffer,
                       sizeof( msgBuffer ),
                       msgId,
                       "LESS.MSG",
                       &outputLength
                     );
   strtok( msgBuffer, "\n\r" );
   return msgBuffer;
}

/*  */

/*  msg_crlf
** Bemerkung
** retrieve a message from the msgfile and insert
** any parameter given.
** The last parameter must be always NULL!
** In difference to msg, the lines will not be truncated
**
** Parameter
** msgId
**
** Return
** ptr to static buffer with the msg
**  */

char *                     msg_crlf(int msgId, ...)

{  static char             msgBuffer[ 2048 ];
   APIRET                  rc;
   ULONG                   varsUsed, outputLength;
   char                    *varsTable[10], *arg;
   va_list                 argPtr;

   outputLength = 0;
   varsUsed     = 0;

   memset( msgBuffer, 0, sizeof( msgBuffer ) );
   memset( &varsTable, 0, sizeof( varsTable ) );

   va_start( argPtr , msgId );

   while ( (arg = va_arg(argPtr, char * )) && varsUsed < 9 )
      varsTable[ varsUsed++ ] = arg;

   va_end( argPtr );

   rc = DosGetMessage( varsTable,
                       varsUsed,
                       msgBuffer,
                       sizeof( msgBuffer ),
                       msgId,
                       "LESS.MSG",
                       &outputLength
                     );
   return msgBuffer;
}

/*  */

/*  updateStatus
** Bemerkung
** update the statusline at the bottom the screen
**
** Parameter
**
**
** Return
**
**  */

void                       updateStatus(void)

{  char                    tempString1[16],tempString2[16],tempString3[16],
                           tempString4[8];
   int                     currentProz;

   if ( !gbl.readData.tid || gbl.cli_liveUpdate )
      {

      switch ( gbl.currentMode )
         {
         case ASCII_VIEW:                 /* *** Normal ASCII View *** */

                                          if ( (gbl.dataLines > BOTTOM) && ( (gbl.dataLines/100) > 0) )
                                             {

                                             currentProz = (gbl.maxDisp - BOTTOM) / (gbl.dataLines/100);
                                             if (currentProz > 100)
                                                currentProz = 100;

                                             sprintf( tempString1, "%3d%%%%",  currentProz);
                                             sprintf( tempString2, "%8d", gbl.maxDisp );
                                             sprintf( tempString3, "%8d", gbl.dataLines );
                                             if ( gbl.lineOffset )
                                                sprintf( tempString4, "[+%04d]", gbl.lineOffset );
                                             else
                                                strcpy( tempString4,"       " );
                                             }
                                          else
                                             {
                                             strcpy(  tempString1, "100%" );
                                             sprintf( tempString2, "%8d", gbl.maxDisp );
                                             sprintf( tempString3, "%8d", gbl.dataLines );
                                             if ( gbl.lineOffset )
                                                sprintf( tempString4, "[+%04d]", gbl.lineOffset );
                                             else
                                                strcpy( tempString4,"       " );
                                             }
                                          writeFullStr( 0,BOTTOM, msg(MSG_LESS_STATUSLINE, tempString1, tempString2, tempString3, tempString4, gbl.searchInfo, NULL) );
                                          break;

         case  HEX_VIEW:                  /* *** Hexview *** */

                                          sprintf( tempString1, "%08X", gbl.hexOffset );
                                          sprintf( tempString2, "%08X", gbl.totalSize );

                                          writeFullStr( 0,BOTTOM, msg(MSG_LESS_HEXSTATUSLINE, tempString1, tempString2, gbl.searchInfo, NULL) );
                                          break;

         }
      paintArea( 0, BOTTOM, RIGHT+1, gbl.colors[gbl.colorSet][STATUSLINE] );
      }
}

/*  */

/*  offsetAt
** Bemerkung
** find a offset for a given line number
**
**
**
** Parameter
** lineIndex               logical line number
**
** Return
** the index of the first byte of that line
**  */

unsigned long              offsetAt( int lineIndex )

{  line                    *linePtr=gbl.row;
   unsigned long           offset=0;

   while ( linePtr && lineIndex-- )
      {
      offset += linePtr->length;
      linePtr=linePtr->next;
      }

   return offset;
}


/*  */



/*  lineAt
** Bemerkung
** returns a ptr to a corresponding line number
**
** Parameter
** lineIndex               logical line number
**
** Return
** ptr to the linked list entry
**  */

line *                     lineAt( int lineIndex )

{  line                    *linePtr=gbl.row;

   static int              lastLine;
   static line             *lastPtr;

   /*
   ** a very simple cache
   */

   if ( lastPtr && (lastLine < lineIndex) )
      {  int      oldIndex;

      oldIndex    = lineIndex;
      lineIndex  -= lastLine;
      lastLine    = oldIndex;
      linePtr     = lastPtr;
      }
   else
      lastLine    = lineIndex;

   while ( linePtr && lineIndex-- )
      linePtr=linePtr->next;

   lastPtr     = linePtr;

   return linePtr;
}

/*  */



/*  offsetChar
** Bemerkung
** return a character at a specific offset
** (the last used offest is cached in lastOffset)
**
**
** Parameter
** wantedOffset            the absolute offset from the beginning
**
** Return
** byte at that position
**  */

char                       offsetChar( unsigned long wantedOffset )

{  static line             *linePtr;
   static unsigned long    lastOffset;
   unsigned long           offset;

   if ( linePtr && (lastOffset < wantedOffset) )
      offset   = lastOffset;
   else
      {
      linePtr = gbl.row;
      offset  = 0;
      }

   while ( linePtr )
      {
      if ( offset + linePtr->length > wantedOffset )
         break;
      offset += linePtr->length;
      linePtr = linePtr->next;
      }

   lastOffset = offset;

   if ( linePtr )
      return *(linePtr->buffer + (wantedOffset-offset) );

   return '?';
}

/*  */



/*  makeHexline
** Bemerkung
** formats a hexbuffer for an given offset
**
** Parameter
** offset                  absolute offset from the beginning
** buffer                  ptr to an allocated buffer
**
** Return
**
**  */

void                       makeHexline(unsigned long offset, char *buffer)

{  char                    character;
   int                     t;

   sprintf( buffer, "%08X |", offset );

   for (t=10; t<RIGHT-1; t++)
      *(buffer+t)=32;
   *(buffer+t)=0;

   for ( t=0; t<HEXCHUNK; t++ )
      {
      if ( offset+t < gbl.totalSize )
         {
         character = offsetChar( offset+t );
         sprintf( buffer+12+t*3,  "%02X ", character );

         if ( character > 31 )
            *(buffer + RIGHT - HEXCHUNK + t) = character;
         else
            *(buffer + RIGHT - HEXCHUNK + t) = '.';
         }
      else
         sprintf( buffer+12+t*3,  "   " );
      }
   *(buffer+12+t*3)= ' ';
}

/*  */



/*  colorLine
** Bemerkung
** color the find result, if there are hits
** in this line
**
**
** Parameter
** y                       row on screen
** linePtr                 ptr to lineData
** Return
** 0        line contains no hits
** 1        line contains hits
**  */

int                        colorLine( int row, line *linePtr )

{

   paintArea( 0, row, RIGHT+1, gbl.colors[gbl.colorSet][BACKGROUND]);
   if ( gbl.showFindResults )
      {
      if ( linePtr->isFindResult )
         {
         if ( gbl.showFullLine )
            paintArea( 0, row, RIGHT+1, gbl.colors[gbl.colorSet][HILITETEXT] );
         else
            hitMarkings( row, linePtr );
         return 1;
         }
      }
   return 0;
}

/*  */


/*  showPage
** Bemerkung
** display the actual page
**
** Parameter
**
**
** Return
**
**  */

void                       showPage(void)

{  char                    tempLine[128], character;
   int                     t, s, u, lastLine, length, row;
   line                    *linePtr;
   unsigned long           offset;


   switch ( gbl.currentMode )
      {
      case  ASCII_VIEW:                /* *** Normal ASCII-view *** */

                                       lastLine = BOTTOM;
                                       if ( BOTTOM > gbl.dataLines )
                                          lastLine = gbl.dataLines;

                                       if ( gbl.maxDisp < lastLine )
                                          gbl.maxDisp = lastLine;

                                       for (t=0; t<lastLine; t++)
                                          {
                                          linePtr = lineAt(gbl.maxDisp - lastLine + t);
                                          if ( linePtr->length > gbl.lineOffset )
                                             writeFullStr( 0,t, linePtr->buffer + gbl.lineOffset );
                                          else
                                             writeFullStr( 0,t, "" );
                                          colorLine( t, linePtr );
                                          }
                                       break;

      case  HEX_VIEW:                  /* *** Hex-view *** */

                                       row = 0;
                                       for ( offset=gbl.hexOffset; offset<gbl.totalSize; offset+=16 )
                                          {
                                          makeHexline( offset, tempLine );
                                          writeFullStr( 0,row, tempLine );
                                          row++;
                                          if (row>=BOTTOM)
                                             break;
                                          }
                                       break;


      }
}

/*  */

/*  showHelp
** Bemerkung
** Display helppage
**
** Parameter
**
**
** Return
**
**  */

void                       showHelp(void)

{  APIRET                  rc;
   char                    *helpLines, *beginOfLine, tempLine[128];
   int                     currentHelpPage, nothingHappend, line, t;
   KBDKEYINFO              key;
   win                     *helpWindow;


   for (t=0; t<10; t++ )
      {
      if ( !request_screenSem() )
         break;
      }
   if ( t>9 )
      return;

   helpWindow = window( 1,1,78,23, SINGLE );
   if (helpWindow)
      {

      currentHelpPage = 1;
      nothingHappend  = 0;

      do
         {

         if ( !nothingHappend )
            {

            helpLines = msg_crlf( MSG_LESS_HELPINFO_PAGE1 + currentHelpPage - 1, NULL);
            line = 2;

            frame( 1,1,78,23, SINGLE );
            while ( *helpLines )
               {

               /*
               ** Zeile lschen
               */

               beginOfLine = helpLines;
               while ( *helpLines && (*helpLines != '\n') && (*helpLines != '\r') )
                  helpLines++;

               memset( tempLine, 0, sizeof( tempLine ) );
               strncpy( tempLine, beginOfLine, helpLines - beginOfLine );

               if ((*helpLines == '\n') || (*helpLines == '\r'))
                  helpLines++;
               if ((*helpLines == '\n') || (*helpLines == '\r'))
                  helpLines++;

               putString( 3, line++, tempLine );
               }

            }

         rc = KbdCharIn( &key, IO_WAIT, 0 );

         nothingHappend=0;
         switch ( key.chScan )
            {
            case  71:                     /* *** HOME *** */

                                          currentHelpPage=1;
                                          moveHOME();
                                          break;

            case  79:                     /* *** END *** */

                                          currentHelpPage=1;
                                          break;

            case  73:                     /* *** PGUP *** */

                                          if ( currentHelpPage > 1)
                                             currentHelpPage--;
                                          break;

            case  81:                     /* *** PGDN *** */

                                          if ( currentHelpPage < MAX_HELPPAGE )
                                             currentHelpPage++;
                                          break;

            default:                      /* *** ignore *** */
                                          nothingHappend=1;
                                          break;
            }
         }
      while ( key.chChar != 27  );
      closeWindow( helpWindow );
      }
   release_screenSem();
}

/*  */



/*  moveUP
** Bemerkung
** move one line up
**
** Parameter
**
**
** Return
** 0
**  */

int                        moveUP( void )

{  char                    tempLine[128];
   line                    *linePtr;

   switch ( gbl.currentMode )
      {
      case ASCII_VIEW:                 /* *** Normal ASCII View *** */

                                       if ( gbl.maxDisp - BOTTOM > 0 )
                                          {
                                          scrollDown(1);
                                          gbl.maxDisp--;
                                          linePtr = lineAt( gbl.maxDisp - BOTTOM );
                                          writeFullStr( 0, 0, linePtr->buffer );
                                          colorLine( 0, linePtr );
                                          updateStatus();
                                          }
                                       else
                                          gbl.viewLoopWin = message( msg(MSG_LESS_BEG_OF_FILE, NULL) );
                                       return 0;

      case HEX_VIEW:                   /* *** Hexview *** */

                                       if ( gbl.hexOffset > 0 )
                                          {
                                          gbl.hexOffset -= HEXCHUNK;
                                          scrollDown(1);
                                          makeHexline( gbl.hexOffset, tempLine );
                                          writeFullStr( 0, 0, tempLine );
                                          updateStatus();
                                          }
                                       else
                                          gbl.viewLoopWin = message( msg(MSG_LESS_BEG_OF_FILE, NULL) );
                                       break;
      }
   return 0;
}

/*  */


/*  moveDOWN
** Bemerkung
** move one line down
**
** Parameter
**
**
** Return
** 0
**  */

int                        moveDOWN( void )

{  char                    tempLine[128];
   line                    *linePtr;

   switch ( gbl.currentMode )
      {
      case  ASCII_VIEW:                /* *** Normal ASCII View *** */

                                       if ( gbl.maxDisp < gbl.dataLines )
                                          {
                                          scrollUp(1);
                                          linePtr = lineAt(gbl.maxDisp);
                                          gbl.maxDisp++;
                                          if ( linePtr )
                                             {
                                             writeFullStr( 0, BOTTOM-1, linePtr->buffer);
                                             colorLine( BOTTOM-1, linePtr );
                                             updateStatus();
                                             }
                                          }
                                       else
                                          gbl.viewLoopWin = message( msg(MSG_LESS_END_OF_FILE, NULL) );
                                       return 0;

      case  HEX_VIEW:                  /* *** Hexview *** */

                                       if ( gbl.hexOffset + HEXCHUNK + HEXPAGE < gbl.totalSize )
                                          {
                                          scrollUp(1);
                                          gbl.hexOffset += HEXCHUNK;
                                          makeHexline( gbl.hexOffset + HEXPAGE, tempLine );
                                          writeFullStr( 0, BOTTOM-1, tempLine );
                                          updateStatus();
                                          }
                                       else
                                          gbl.viewLoopWin = message( msg(MSG_LESS_END_OF_FILE, NULL) );
                                       return 0;
      }
   return 0;
}

/*  */


/*  moveHOME
** Bemerkung
** move to the beginning of the file
**
** Parameter
**
**
** Return
** 0
**  */

int                        moveHOME( void )

{
   switch ( gbl.currentMode )
      {
      case  ASCII_VIEW:                /* *** Normal ASCII View *** */

                                       gbl.maxDisp = BOTTOM;
                                       showPage();
                                       updateStatus();
                                       return 0;

      case  HEX_VIEW:                  /* *** Hexview *** */

                                       gbl.hexOffset = 0;
                                       showPage();
                                       updateStatus();
                                       return 0;
      };

   return 0;
}

/*  */

/*  moveEND
** Bemerkung
** move to the end of file
**
** Parameter
**
**
** Return
** 0
**  */

int                        moveEND( void )

{
   switch ( gbl.currentMode )
      {
      case  ASCII_VIEW:                /* *** Normal ASCII View *** */

                                       gbl.maxDisp = gbl.dataLines;
                                       showPage();
                                       updateStatus();
                                       return 0;

      case  HEX_VIEW:                  /* *** Hexview *** */

                                       if ( gbl.totalSize > HEXPAGE )
                                          gbl.hexOffset = gbl.totalSize - HEXPAGE;

                                       showPage();
                                       updateStatus();
                                       return 0;
      };
   return 0;
}

/*  */

/*  movePGDN
** Bemerkung
** move one page down
**
** Parameter
**
**
** Return
** 0
**  */

int                        movePGDN( void )

{  int                     t;

   switch ( gbl.currentMode )
      {
      case  ASCII_VIEW:                /* *** Normal ASCII View *** */

                                       if ( gbl.maxDisp + BOTTOM < gbl.dataLines)
                                          gbl.maxDisp += BOTTOM;
                                       else
                                          gbl.maxDisp = gbl.dataLines;

                                       showPage();
                                       updateStatus();

                                       return 0;

      case  HEX_VIEW:                  /* *** Hexview *** */

                                       if ( gbl.totalSize > HEXPAGE )
                                          {

                                          if ( gbl.hexOffset + HEXPAGE < gbl.totalSize )
                                             gbl.hexOffset += HEXPAGE;

                                          while ( gbl.hexOffset > (gbl.totalSize - HEXPAGE) )
                                             gbl.hexOffset -= HEXCHUNK;

                                          showPage();
                                          updateStatus();
                                          }

                                       return 0;
      };
   return 0;
}

/*  */

/*  movePGUP
** Bemerkung
** move one page up
**
** Parameter
**
**
** Return
**
**  */

int                        movePGUP( void )

{
   switch ( gbl.currentMode )
      {
      case  ASCII_VIEW:                /* *** Normal ASCII View *** */

                                       if ( gbl.maxDisp - BOTTOM > BOTTOM )
                                          gbl.maxDisp -= BOTTOM;
                                       else
                                          gbl.maxDisp = BOTTOM;

                                       if ( gbl.maxDisp > gbl.dataLines )
                                          gbl.maxDisp = gbl.dataLines;

                                       showPage();
                                       updateStatus();
                                       return 0;

      case  HEX_VIEW:                  /* *** Hexview *** */

                                       if ( gbl.hexOffset > HEXPAGE )
                                          gbl.hexOffset -= HEXPAGE;
                                       else
                                          gbl.hexOffset = 0;

                                       showPage();
                                       updateStatus();

                                       return 0;
      };
   return 0;
}

/*  */


/*  viewLoop
** Bemerkung
** process the user input
**
** Parameter
**
**
** Return
**
**  */

void                       viewLoop(void)

{  APIRET                  rc;
   KBDKEYINFO              key;
   win                     *msgWin;

   gbl.viewLoopWin = NULL;

   showPage();
   updateStatus();

   do
      {

      rc = KbdCharIn( &key, IO_WAIT, 0 );

      #ifndef RELEASE
         writeStr( 70, BOTTOM, "scan: %d", key.chScan );
      #endif

      if ( gbl.viewLoopWin )
         {
         closeWindow( gbl.viewLoopWin );
         gbl.viewLoopWin = NULL;
         }

      switch ( key.chScan )
         {
         case  3:                      /* *** 2  switch to 25 line mode *** */

                                       initVideo( 25, 80 );
                                       showPage();
                                       updateStatus();
                                       break;

         case  4:                      /* *** 3  switch to 30 line mode *** */

                                       initVideo( 30, 80 );
                                       showPage();
                                       updateStatus();
                                       break;

         case  6:                      /* *** 5  switch to 50 line mode *** */

                                       initVideo( 50, 80 );
                                       showPage();
                                       updateStatus();
                                       break;

         case  78:                     /* *** make screen 4 columns wider *** */

                                       if ( RIGHT < 100 )
                                          {
                                          RIGHT += 4;
                                          initVideo( BOTTOM + 1, RIGHT + 1 );
                                          showPage();
                                          updateStatus();
                                          }
                                       break;

         case  74:                     /* *** make screen 4 columns smaller *** */

                                       if ( RIGHT > 40 )
                                          {
                                          RIGHT -= 4;
                                          initVideo( BOTTOM + 1, RIGHT + 1 );
                                          showPage();
                                          updateStatus();
                                          }
                                       break;

         case  48:                     /* *** B  [TOGGLE: Color / Black&White] *** */

                                       if ( gbl.colorSet == MONO )
                                          gbl.colorSet = COLOUR;
                                       else
                                          gbl.colorSet = MONO;

                                       showPage();
                                       updateStatus();
                                       break;

         case  46:                     /* *** C  [TOGGLE: Filter Control Chars] *** */

                                       gbl.filterControlChars ^= 1;
                                       showPage();
                                       if ( gbl.filterControlChars )
                                          gbl.viewLoopWin = message( msg(MSG_LESS_FILTER_CONTROL_CHARS, NULL) );
                                       else
                                          gbl.viewLoopWin = message( msg(MSG_LESS_SHOW_CONTROL_CHARS, NULL) );
                                       break;

         case  25:                     /* *** P  [TOGGLE: partial / Fullline marking] *** */

                                       if ( gbl.showFullLine )
                                          gbl.showFullLine = 0;
                                       else
                                          gbl.showFullLine = 1;

                                       showPage();
                                       updateStatus();
                                       break;

         case  59:                     /* *** F1 *** */

                                       showHelp();
                                       break;

         case  62:                     /* *** F4 *** */

                                       if (gbl.currentMode == ASCII_VIEW)
                                          {
                                          gbl.currentMode = HEX_VIEW;
                                          if ( gbl.maxDisp > BOTTOM )
                                             gbl.hexOffset = offsetAt( gbl.maxDisp - BOTTOM );
                                          else
                                             gbl.hexOffset = 0;
                                          }
                                       else
                                          gbl.currentMode = ASCII_VIEW;
                                       showPage();
                                       break;

         case  65:                     /* *** F7 *** */

                                       if ( !gbl.isSearchRunning )
                                          {  char        *searchExp;
                                             win         *searchWin;

                                          searchWin = window( 10,10, 60, 4, SINGLE );
                                          if ( searchWin )
                                             {
                                             putString( 11,11, msg(MSG_LESS_SEARCH_WINDOW,NULL) );
                                             if ( !getString( 11,12, MAX_SEARCH_LENGTH, DISPLAY_DEFAULT, &searchExp, gbl.lastExp) )
                                                {
                                                /*
                                                ** searchExp will be freed at
                                                ** end of searchThread
                                                */
                                                strcpy( gbl.lastExp, searchExp );
                                                gbl.searchData.searchPattern = searchExp;
                                                gbl.searchData.tid = _beginthread( searchThread, NULL, THREAD_STACK, &gbl.searchData );
                                                }
                                             closeWindow( searchWin );
                                             }
                                          }
                                       else
                                          gbl.viewLoopWin = message( msg(MSG_LESS_SEARCH_IS_RUNNING, NULL) );

                                       break;

         case  90:                     /* *** SHIFT F7 *** */

                                       {  int         currentLine;
                                          line        *linePtr;

                                       currentLine = gbl.maxDisp - BOTTOM + 1;
                                       if (currentLine < 0 )
                                          currentLine = 0;
                                       linePtr = lineAt( currentLine );

                                       while ( linePtr )
                                          {
                                          if ( linePtr->isFindResult )
                                             break;
                                          currentLine++;
                                          linePtr=linePtr->next;
                                          }

                                       if ( linePtr )
                                          {
                                          if ( currentLine + BOTTOM < gbl.dataLines )
                                             gbl.maxDisp = currentLine + BOTTOM;
                                          else
                                             gbl.maxDisp = gbl.dataLines;

                                          showPage();
                                          updateStatus();
                                          }
                                       }
                                       break;

         case  72:                     /* *** UP *** */

                                       moveUP();
                                       break;

         case  75:                     /* *** LEFT *** */

                                       if (gbl.currentMode == ASCII_VIEW)
                                          if ( gbl.lineOffset )
                                             {
                                             --gbl.lineOffset;
                                             showPage();
                                             updateStatus();
                                             }
                                       break;

         case  77:                     /* *** RIGHT *** */

                                       if (gbl.currentMode == ASCII_VIEW)
                                          {
                                          ++gbl.lineOffset;
                                          showPage();
                                          updateStatus();
                                          }
                                       break;

         case  80:                     /* *** DOWN *** */

                                       moveDOWN();
                                       break;

         case  71:                     /* *** HOME *** */

                                       moveHOME();
                                       break;

         case  79:                     /* *** END *** */

                                       moveEND();
                                       break;

         case  73:                     /* *** PGUP *** */

                                       movePGUP();
                                       break;

         case  81:                     /* *** PGDN *** */

                                       movePGDN();
                                       break;
         }
      }
   while ( key.chChar != 27  );
}

/*  */



/*  main
** Bemerkung
** main ...
**
** Parameter
**
**
** Return
**
**  */

int                        main( int argc, char *argv[] )

{  APIRET                  rc;

   /*
   ** register signal handler
   */

   signal( SIGINT,   (_SigFunc) exitHandler);
   signal( SIGBREAK, (_SigFunc) exitHandler);
   signal( SIGABRT,  (_SigFunc) exitHandler);
   signal( SIGTERM,  (_SigFunc) exitHandler);
   signal( SIGSEGV,  (_SigFunc) exitHandler);

   /*
   ** init and run app
   */

   init( argc, argv );
   viewLoop();

   /*
   ** terminate app
   */

   gbl.readData.appRunning = 0;

   writeFullStr( 0,BOTTOM, msg(MSG_LESS_WAITTHREADS, NULL) );
   if ( gbl.readData.tid )
      rc = DosWaitThread( &gbl.readData.tid, DCWW_WAIT );

   /*
   ** unregister handler
   */

   signal( SIGINT,      SIG_DFL );
   signal( SIGBREAK,    SIG_DFL );
   signal( SIGABRT,     SIG_DFL );
   signal( SIGTERM,     SIG_DFL );
   signal( SIGSEGV,     SIG_DFL );

   return 0;
}

/*  */


