/* Datei: lessinit.c
** angegelegt am 1/13/1998
**
** program initialization and termination
**
** RCS: $Id: lessinit.c.# 0.2 1998/03/07 19:45:44 CBENDEN Exp $
**
**  less - an a simple pager for OS/2
**  Copyright (C) 1998  Clemens Maria Benden   (cbenden@netproject.de)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**       You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
**  ---------------- Datei-Log ---------------------
**  $Log: lessinit.c.# $
**Revision 0.2  1998/03/07  19:45:44  CBENDEN
**- Build Version 0.2
**
**Revision 0.1  1998/02/04  12:57:40  CBENDEN
**initial checkin
**
**  -------------- Datei-Log Ende ------------------
*/

/*  *** Local Defines *** *** */

/*  *** Includes *** *** */

   #include    "..\include\lessinit.h"

   #include <pmerr.h>

/*  *** Globals / Statics *** *** */

   static win              *savedScreen;
   static VIOCURSORINFO    cursorInfo;
   static VIOMODEINFO      videoMode;

/*  *** Externals *** *** */

   extern globalData       gbl;


/*  init
** Bemerkung
** handle the program initialization
**
** Parameter
** argc+argv               commandline parameters
**
**
** Return
** 0     init was ok
** 1     cant alloc sems
** 2     cant init threads
**  */

int                        init(int argc, char *argv[] )

{  APIRET                  rc;

   atexit( cleanup );

   initVars();
   initPars( argc, argv );

   if ( allocSems() )
      return 1;

   if ( initThreads() )
      return 2;

   loadIni();

   rc = VioGetCurType( &cursorInfo, 0 );
   savedScreen = window(0, 0, RIGHT+1, BOTTOM+1, NO_FRAME );

   cls( gbl.colors[gbl.colorSet][NORMALTEXT] );
   paintArea( 0, BOTTOM, RIGHT+1, gbl.colors[gbl.colorSet][STATUSLINE] );

   return 0;
}

/*  */

/*  parseCommandline
** Bemerkung
** parse a string for comandline parameters
**
**
**
** Parameter
**
**
** Return
**
**  */

int                        parseCommandline( char *charPtr )

{
   if ( *charPtr++ != '-' )
      {
      if ( gbl.cli_filename[0] )
         {
         printf( msg_crlf( MSG_LESS_DASH_MISSING, NULL ) );
         exit(1);
         }
      strcpy( gbl.cli_filename, --charPtr );
      return 0;
      }

   switch ( *charPtr++ )
      {
      case  '?':                       /*
                                       ** Usage
                                       */
                                       printf( msg_crlf( MSG_USAGE, NULL ) );
                                       exit(2);

      case  'b':                       /*
                                       ** open in binary mode
                                       */

                                       gbl.cli_binary = 1;
                                       break;

      case  'h':                       /*
                                       ** start in hexmode
                                       */

                                       gbl.currentMode = HEX_VIEW;
                                       break;

      case  'j':                       /*
                                       ** jump to end (when in liveMode)
                                       */

                                       gbl.cli_jumpEnd = 1;
                                       break;


      case  'u':                       /*
                                       ** do not stop reading input
                                       ** and wait for further data
                                       ** (liveMode)
                                       */

                                       gbl.cli_liveUpdate = 1;
                                       break;

      default:                         /*
                                       ** unknown option
                                       */

                                       printf( msg( MSG_UNKNOWN_CLI_OPTION, --charPtr, NULL ) );
                                       exit(1);
      }
   return 0;
}

/*  */


/*  cleanup
** Bemerkung
** called at programm termincation to free used
** resources
**
** Parameter
**
**
** Return
**
**  */

void                       cleanup(void)

{  APIRET                  rc;

   gbl.isExiting              = 1;
   gbl.readData.appRunning    = 0;
   gbl.searchData.appRunning  = 0;

   /*
   ** wait some time to allow the threads
   ** to exit gracefully
   */

   DosSleep( 300 );

   closeSems();

   if ( gbl.readData.tid )
      {
      DosKillThread( gbl.readData.tid );
      gbl.readData.tid=0;
      }

   if ( gbl.searchData.tid )
      {
      DosKillThread( gbl.searchData.tid );
      gbl.searchData.tid=0;
      }

   rc = VioSetMode( &videoMode, 0 );
   if (savedScreen)
      copybuffer( savedScreen );

   rc = VioSetCurType( &cursorInfo, 0 );

   termSearch();
   if ( gbl.hab )
      {
      WinTerminate( gbl.hab );
      }
}

/*  */

/*  initThreads
** Bemerkung
** start threads
**
** Parameter
**
**
** Return
** 0
**  */

int                        initThreads(void)

{
   gbl.readData.tid = _beginthread( readThread, NULL, THREAD_STACK, &gbl.readData );

   return 0;
}

/*  */

/*  initPars
** Bemerkung
**
**
**
**
** Parameter
**
**
** Return
**
**  */

void                       initPars(int argCount, char *argString[] )

{  int                     rc;

   if (getenv( "LESS") )
      parseCommandline( getenv("LESS") );

   ++argString;

   while ( *argString )
      {
      if ( *argString && (rc=parseCommandline( *argString++ )) )
         break;
      }
}

/*  */


/*  initVars
** Bemerkung
** initialize the global vars with the correct
** values
**
** Parameter
**
**
** Return
**
**  */

void                       initVars(void)

{  APIRET                  rc;

   memset( &gbl, 0, sizeof(gbl) );
   savedScreen          = NULL;

   gbl.filterControlChars     = 1;
   gbl.showFindResults        = 1;
   gbl.showFullLine           = 1;
   gbl.readData.appRunning    = 1;
   gbl.currentMode            = ASCII_VIEW;

   videoMode.cb = sizeof( videoMode );
   rc = VioGetMode( &videoMode, 0 );
   if ( !rc )
      {
      gbl.bottom                 = videoMode.row - 1;
      gbl.right                  = videoMode.col - 1;
      }
   else
      {
      gbl.bottom                 = 24;
      gbl.right                  = 79;
      }

   gbl.hexChunk               = 16;
   gbl.hexPage                = gbl.hexChunk * gbl.bottom;

   gbl.bufferSize             = 0x2000;

   /*
   ** Colors
   */

   gbl.colors[MONO][BACKGROUND]     = 0x07;
   gbl.colors[MONO][WINDOWFRAME]    = 0x07;
   gbl.colors[MONO][NORMALTEXT]     = 0x07;
   gbl.colors[MONO][HILITETEXT]     = 0x0F;
   gbl.colors[MONO][ENTRYFIELD]     = 0x70;
   gbl.colors[MONO][STATUSLINE]     = 0x70;
   gbl.colors[MONO][MARKEDLINE]     = 0x20;

   gbl.colors[COLOUR][BACKGROUND]    = 0x1F;
   gbl.colors[COLOUR][WINDOWFRAME]   = 0x1F;
   gbl.colors[COLOUR][NORMALTEXT]    = 0x17;
   gbl.colors[COLOUR][HILITETEXT]    = 0x1E;
   gbl.colors[COLOUR][ENTRYFIELD]    = 0x3E;
   gbl.colors[COLOUR][STATUSLINE]    = 0x73;
   gbl.colors[COLOUR][MARKEDLINE]    = 0x72;

   gbl.hab = WinInitialize( 0 );

}

/*  */

/*  loadIni
** Bemerkung
**
**
**
**
** Parameter
**
**
** Return
**
**  */

void                       loadIni(void)

{  APIRET                  rc;
   char                    iniName[256], *charPtr, *buffer, *buffer2,
                           iniVersion[32];
   HINI                    lessini;
   ULONG                   size;

   if ( getenv("ETC" ) )
      {
      strcpy( iniName, getenv("ETC") );
      MAKEPATH( iniName );
      strcat( iniName, "less.ini" );

      lessini = PrfOpenProfile( gbl.hab, iniName );
      if ( lessini )
         {

         size = sizeof( iniVersion );
         memset( iniVersion, 0, size );

         rc = PrfQueryProfileData( lessini, "LESS", "INIVERSION", iniVersion, &size );

         if ( !strcmp( iniVersion, INI_VERSION_10) )
            readIni_10( lessini );

         PrfCloseProfile( lessini );
         }
      else
         {  APIRET         rc;
            char           tempNum[32];
            ERRORID        errorCode;
            KBDKEYINFO     key;
            win            *errMsg=0;

         errorCode = WinGetLastError( gbl.hab );
         sprintf( tempNum, "%d", (int) errorCode );
         switch ( errorCode )
            {
            case  PMERR_OPENING_INI_FILE:       errMsg=message(msg(MSG_ERROR_OPENINI,iniName, NULL) ); break;
            case  PMERR_MEMORY_ALLOC:           errMsg=message(msg(MSG_ERROR_SYS_MEMALLOC,iniName, NULL) ); break;
            default:                            errMsg=message(msg(MSG_ERROR_UNEXSPECT_INIERROR, tempNum, iniName, NULL) ); break;
            }

         if ( errMsg )
            {
            rc = KbdCharIn( &key, IO_NOWAIT, 0 );
            closeWindow( errMsg );
            }
         }
      }

}

/*  */

/*  readIni_10
** Bemerkung
** readin ini-version 1.0
**
** Parameter
**
**
** Return
**
**  */

void                       readIni_10(HINI lessini)

{  APIRET                  rc;
   char                    tempString[32];
   int                     t;
   ULONG                   size;


   size = sizeof( gbl.colorSet );
   rc = PrfQueryProfileData( lessini, "LESS", "COLORSET", &gbl.colorSet, &size );

   for (t=0; t<MAX_COLORSET; t++)
      {
      sprintf( tempString, "COLOURSET-%d", t );
      size = sizeof( gbl.colors[t][BACKGROUND] );
      rc = PrfQueryProfileData( lessini, tempString, "BACKGROUND",   &gbl.colors[t][BACKGROUND], &size );
      size = sizeof( gbl.colors[t][NORMALTEXT] );
      rc = PrfQueryProfileData( lessini, tempString, "NORMALTEXT",   &gbl.colors[t][NORMALTEXT], &size );
      size = sizeof( gbl.colors[t][WINDOWFRAME] );
      rc = PrfQueryProfileData( lessini, tempString, "WINDOWFRAME",  &gbl.colors[t][WINDOWFRAME], &size );
      size = sizeof( gbl.colors[t][HILITETEXT] );
      rc = PrfQueryProfileData( lessini, tempString, "HILITETEXT",   &gbl.colors[t][HILITETEXT], &size );
      size = sizeof( gbl.colors[t][ENTRYFIELD] );
      rc = PrfQueryProfileData( lessini, tempString, "ENTRYFIELD",   &gbl.colors[t][ENTRYFIELD], &size );
      size = sizeof( gbl.colors[t][STATUSLINE] );
      rc = PrfQueryProfileData( lessini, tempString, "STATUSLINE",   &gbl.colors[t][STATUSLINE], &size );
      size = sizeof( gbl.colors[t][MARKEDLINE] );
      rc = PrfQueryProfileData( lessini, tempString, "MARKEDLINE",   &gbl.colors[t][MARKEDLINE], &size );
      }
}

/*  */

