/* Datei: lesssem.c
** angegelegt am 1/13/1998
**
** Allocating and working with Semaphores
**
** RCS: $Id: lesssem.c.# 0.2 1998/03/07 19:45:50 CBENDEN Exp $
**
**  less - an a simple pager for OS/2
**  Copyright (C) 1998  Clemens Maria Benden   (cbenden@netproject.de)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**       You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
**  ---------------- Datei-Log ---------------------
**  $Log: lesssem.c.# $
**Revision 0.2  1998/03/07  19:45:50  CBENDEN
**- Build Version 0.2
**
**Revision 0.1  1998/02/04  12:57:59  CBENDEN
**initial checkin
**
**  -------------- Datei-Log Ende ------------------
*/

/*  *** Local Defines *** *** */

/*  *** Includes *** *** */

   #include    "..\include\lesssem.h"

/*  *** Globals / Statics *** *** */

/*  *** Externals *** *** */

   extern   globalData     gbl;

/*  allocSems
** Bemerkung
** Allocates all semaphores
**
** Parameter
**
**
** Return
**
**  */

int                        allocSems(void)

{  APIRET                  rc;

   rc = DosCreateMutexSem( "\\SEM32\\BNS\\LESS\\LINEBUFFER",
                           &gbl.lineBufferSem,
                           0,
                           0
                         );

   if ( !rc )
      rc = DosCreateMutexSem( "\\SEM32\\BNS\\LESS\\SEARCHRUNNING",
                              &gbl.searchRunningSem,
                              0,
                              0
                            );

      if ( !rc )
         rc = DosCreateMutexSem( "\\SEM32\\BNS\\LESS\\SCREEN",
                                 &gbl.screenSem,
                                 0,
                                 0
                               );

   if (rc)
      return rc;

   return 0;
}

/*  */

/*  closeSems
** Bemerkung
** free all allocated semaphore handles
**
** Parameter
**
**
** Return
** 0          ok
** !0         APIRET error code
**  */

int                        closeSems(void)

{  APIRET                  rc;

   rc = DosCloseMutexSem( gbl.lineBufferSem );
   rc = DosCloseMutexSem( gbl.searchRunningSem );
   rc = DosCloseMutexSem( gbl.screenSem );

   return rc;
}

/*  */

/*  request_lineBufferSem
** Bemerkung
** request the linebuffer sem, which allows the owning thread
** to manipulate the global linedata
**
** Parameter
**
**
** Return
** 0     the semaphore is now owned -> continue
** !0    APIRET error code
**  */

int                        request_lineBufferSem(void)

{  APIRET                  rc;

   rc = DosRequestMutexSem( gbl.lineBufferSem, SEM_TIMEOUT );
   return rc;
}

/*  */

/*  request_searchRunning
** Bemerkung
** request the searchRunning sem, which allows the owning thread
** to change the value of the global flag gbl.isSearchRunning
**
** Parameter
**
**
** Return
** 0     the semaphore is now owned -> continue
** !0    APIRET error code
**  */

int                        request_searchRunningSem(void)

{  APIRET                  rc;

   rc = DosRequestMutexSem( gbl.searchRunningSem, SEM_TIMEOUT );
   return rc;
}

/*  */

/*  request_screenSem
** Bemerkung
** request the screen sem, which allows the owning thread
** to own the screen. eg. showHelp uses this to stop
** screen updates from other threads, which destroys the screen
**
** Parameter
**
**
** Return
** 0     the semaphore is now owned -> continue
** !0    APIRET error code
**  */

int                        request_screenSem(void)

{  APIRET                  rc;

   rc = DosRequestMutexSem( gbl.screenSem, SEM_TIMEOUT );
   return rc;
}

/*  */


/*  release_lineBufferSem
** Bemerkung
** release the linebuffer semaphore for the use
** of other threads
**
** Parameter
**
**
** Return
** 0     the semaphore is now released
** !0    APIRET error code
**  */

int                        release_lineBufferSem(void)

{  APIRET                  rc;

   rc = DosReleaseMutexSem( gbl.lineBufferSem );
   return rc;
}

/*  */

/*  release_searchRunningSem
** Bemerkung
** release the linebuffer semaphore for the use
** of other threads
**
** Parameter
**
**
** Return
** 0     the semaphore is now released
** !0    APIRET error code
**  */

int                        release_searchRunningSem(void)

{  APIRET                  rc;

   rc = DosReleaseMutexSem( gbl.searchRunningSem );
   return rc;
}

/*  */


/*  release_screenSem
** Bemerkung
** release the linebuffer semaphore for the use
** of other threads
**
** Parameter
**
**
** Return
** 0     the semaphore is now released
** !0    APIRET error code
**  */

int                        release_screenSem(void)

{  APIRET                  rc;

   rc = DosReleaseMutexSem( gbl.screenSem );
   return rc;
}

/*  */

