/* Datei: lesssrch.h
** (c) Copyright 1997 by bns
** angegelegt am 2/5/1998
**
** search with regular expressions
**
** RCS: $Id$
**
** Datei
**   Datei-Log 
**  $Log$
**   Datei-Log Ende 
*/

/*  *** Local Defines *** */

/*  *** Includes *** */

   #include    "..\include\lesssrch.h"

/*  *** Globals / Statics *** */

/*  *** Externals *** */

   extern globalData       gbl;
   static char             searchPattern[ MAX_SEARCH_LENGTH + 1];

/*  initSearch
** Bemerkung
** initialize the search routines
**
**
**
** Parameter
** pattern                 the regular pattern
**
** Return
** 0        pattern was ok
**  */

int                        initSearch( char *pattern, int searchFlags )

{  int                     rc=0;

   /*  NOT ANSI-C */
   #ifdef __IBMC__
      int                  regOpt;

      strcpy( searchPattern, pattern);
      regOpt = REG_NEWLINE | REG_ICASE;
      rc = regcomp( &gbl.preg, pattern, regOpt );
      if ( rc )
         return rc;
      return 0;

   #endif
   return rc;
}

/*  */

/*  doSearch
** Bemerkung
**
**
**
**
** Parameter
**
**
** Return
** 0           no match
** 1           one or more matches
** 2           error
**  */

int                        doSearch( char *line )

{  int                     rc = 0;


   /*  NOT ANSI-C */
   #ifdef __IBMC__
      regmatch_t           matches[2];

      if ( regexec(&gbl.preg, line, 2, matches, 0 ) == 0 )
         rc=1;

   #endif

   return rc;
}

/*  */

/*  hitMarkings
** Bemerkung
**
**
**
**
** Parameter
**
**
** Return
**
**  */

void                       hitMarkings(int row, line *linePtr)

{

   /*  NOT ANSI-C */
   #ifdef __IBMC__
      char                    *charPtr;
      int                     rc, t, maxLength, totalLength, currentPos,
                              length, startPos;
      size_t                  nmatch = 2;
      regmatch_t              pmatch[2];
      regex_t                 preg;

      rc = regcomp(&preg, searchPattern, REG_EXTENDED | REG_ICASE);
      if ( rc )
         return;

      charPtr = linePtr->buffer;
      currentPos = 0;
      totalLength = 0;
      maxLength = min( strlen( charPtr ), RIGHT+1 );

      for( ;; )
         {

         if ( regexec(&preg, charPtr , nmatch, pmatch, 0) )
            break;

         length   = pmatch[0].rm_eo - pmatch[0].rm_so;
         startPos = pmatch[0].rm_so;

         paintArea( currentPos + startPos, row, length, gbl.colors[gbl.colorSet][HILITETEXT] );

         currentPos = startPos + length;
         totalLength += currentPos;
         if ( totalLength >= maxLength )
            break;
         charPtr = charPtr + currentPos;
         }

       regfree(&preg);

   #endif
}

/*  */



/*  termSearch
** Bemerkung
** free all used resources
**
** Parameter
**
**
** Return
**
**  */

void                       termSearch()

{
   /*  NOT ANSI-C */
   #ifdef __IBMC__
      regfree( &gbl.preg );
   #endif
}

/*  */

