/* Datei: lessvio.c
** angegelegt am 1/13/1998
**
** vio routines (windows, textoutput and textinput)
**
** RCS: $Id: lessvio.c.# 0.2 1998/03/07 19:45:58 CBENDEN Exp $
**
**  less - an a simple pager for OS/2
**  Copyright (C) 1998  Clemens Maria Benden   (cbenden@netproject.de)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**       You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
**  ---------------- Datei-Log ---------------------
**  $Log: lessvio.c.# $
**Revision 0.2  1998/03/07  19:45:58  CBENDEN
**- Build Version 0.2
**
**Revision 0.1  1998/02/04  12:58:09  CBENDEN
**initial checkin
**
**  -------------- Datei-Log Ende ------------------
*/

/*  *** Local Defines *** *** */

/*  *** Includes *** *** */

   #include    "..\include\lessvio.h"

/*  *** Globals / Statics *** *** */

/*  *** Externals *** *** */

   extern globalData       gbl;

/*  initVideo
** Bemerkung
** initialize the VIO mode (not used - yet)
**
** Parameter
** lines                   wanted lines
** cols                    wanted cols
** Return
** 0        the mode was activated
** !0       error code
**  */

int                        initVideo(int lines, int cols)

{  VIOMODEINFO             modeInfo;
   unsigned int            rc;

   modeInfo.cb = sizeof( modeInfo );
   rc = VioGetMode( &modeInfo, 0 );
   if ( !rc )
      {
      modeInfo.col = cols;
      modeInfo.row = lines;
      rc = VioSetMode( &modeInfo, 0 );
      }

   if ( !rc )
      {

      gbl.bottom                 = lines-1;
      gbl.right                  = cols-1;

      gbl.hexChunk               = 16;
      gbl.hexPage                = gbl.hexChunk * (gbl.bottom-1);

      cls( gbl.colors[ gbl.colorSet ][BACKGROUND] );
      }
   else
      {
      #ifndef RELEASE
         writeStr( 60, BOTTOM, "sm!rc=%X", (int) rc );
      #endif
      }

   return rc;
}

/*  */

/*  cls
** Bemerkung
** clears the whole screen
**
** Parameter
**
**
** Return
**
**  */

int                        cls(char attr)

{  APIRET                  rc;
   BYTE                    cell[2];

   cell[0]  = ' ';
   cell[1]  = attr;

   rc = VioScrollUp( 0, 0, -1, -1, -1, cell, 0 );

   return rc;
}

/*  */


/*  getString
** Bemerkung
** Gets a string from a position
** (caller must free the buffer if it is !NULL)
**
** Parameter
** x,y                     the screen postion
** maxLength               maximum input length
** flags                   control flags for the input routine
** getBuffer               ptr to ptr to inputbuffer
** initialValue            if !NULL the initial value of the buffer
**
** Return
** 0                       enter
** 1                       no memory
** 2                       user pressed ESC
** 3                       prev field
** 4                       next field
**  */

int                        getString( int x, int y, int maxLength, int flags, char **getBuffer, char *initialValue )

{  APIRET                  rc;
   char                    *charPtr;
   int                     actualPos, insertMode, length, t,
                           oldX, oldY;
   KBDKEYINFO              key;
   VIOCURSORINFO           cursorInfo, oldCursor;

   *getBuffer = malloc( maxLength + 1 );
   if ( !*getBuffer )
      return 1;

   /*
   ** hide ptr to ptr
   */
   charPtr = *getBuffer;

   memset( charPtr, 0, maxLength + 1);
   if ( flags & DISPLAY_DEFAULT )
      strncpy( charPtr, initialValue, maxLength );

   paintArea( x, y, maxLength, gbl.colors[gbl.colorSet][ENTRYFIELD] );

   insertMode  = 0;
   length      = strlen( charPtr );
   actualPos   = length;

   rc = VioGetCurType( &oldCursor, 0 );
   oldX = posX();
   oldY = posY();

   cursorInfo.yStart = 0;
   cursorInfo.cEnd   = -100;
   cursorInfo.cx     = 1;
   cursorInfo.attr   = 0;

   rc = VioSetCurType( &cursorInfo, 0 );

   do
      {

      #ifndef RELEASE
         writeStr( 70, BOTTOM, "l:%2d p:%2d", length, actualPos );
      #endif

      writeStr( x,y, charPtr );
      locate( x+actualPos, y );

      rc = KbdCharIn( &key, IO_WAIT, 0 );

      switch ( key.chScan )
         {
         case  1:          /* *** ESC *** */

                           free( charPtr );
                           charPtr = NULL;
                           rc = VioSetCurType( &oldCursor, 0 );
                           locate( oldX, oldY );
                           return 2;

         case  14:         /* *** BACKSPACE *** */

                           if ( actualPos )
                              actualPos--;

                           if ( length )
                              {
                              /*
                              ** delete char in buffer
                              */

                              for (t=actualPos; t<length; t++ )
                                 *(charPtr+t) = *(charPtr+t+1);

                              *(charPtr+t)=0;
                              length--;

                              /*
                              ** delete char on screen
                              */

                              *(charPtr+length)= ' ';
                              writeStr( x,y, charPtr );
                              *(charPtr+length)= 0;
                              }
                           break;

         case  71:         /* *** HOME *** */

                           actualPos = 0;
                           break;

         case  72:         /* *** CURSOR UP *** */

                           if ( flags && LEAVE_FIELD)
                              {
                              rc = VioSetCurType( &oldCursor, 0 );
                              locate( oldX, oldY );
                              return 3;
                              }
                           break;

         case  75:         /* *** CURSOR LEFT *** */

                           if ( actualPos )
                              actualPos--;
                           break;


         case  79:         /* *** END *** */
                           actualPos = length;
                           break;

         case  80:         /* *** CURSOR DOWN *** */

                           if ( flags && LEAVE_FIELD)
                              {
                              rc = VioSetCurType( &oldCursor, 0 );
                              locate( oldX, oldY );
                              return 4;
                              }
                           break;

         case  82:         /* *** INSERT *** */

                           for (t=min( maxLength-2,length); t>=actualPos; t--)
                              *(charPtr+t+1) = *(charPtr+t);

                           *(charPtr+actualPos) = 32;
                           if ( length < maxLength )
                              length++;
                           break;

         case  77:         /* *** CURSOR RIGHT *** */

                           if ( actualPos < length)
                              actualPos++;
                           break;


         default:          /* *** look at ascii-code *** */

                           if ( key.chChar > 31 )
                              {
                              if ( actualPos < maxLength )
                                 {
                                 *(charPtr+actualPos) = key.chChar;
                                 actualPos++;
                                 if ( actualPos > length )
                                    length++;
                                 *(charPtr+length)=0;
                                 }
                              }
                           break;

         }

      }
   while ( key.chChar != 13  );

   rc = VioSetCurType( &oldCursor, 0 );
   locate( oldX, oldY );

   return 0;
}

/*  */

/*  locate
** Bemerkung
** put the cursor at a specific position
** (0,0) is the upper left edge on screen
**
** Parameter
** x,y                     screen position
**
** Return
**
**  */

void                       locate(int x, int y)

{  APIRET                  rc;

   rc = VioSetCurPos( y, x, 0 );
}

/*  */


/*  posX
** Bemerkung
** get the horizontal position of the current
** cursor position
**
** Parameter
**
**
** Return
** current x position
**  */

int                        posX(void)

{  APIRET                  rc;
   USHORT                  col, row;

   rc = VioGetCurPos( &row, &col, 0);
   return col;
}

/*  */


/*  posY
** Bemerkung
** get the vertical position of the current
** cursor position
**
** Parameter
**
**
** Return
** current y position
**  */

int                        posY(void)

{  APIRET                  rc;
   USHORT                  col, row;

   rc = VioGetCurPos( &row, &col, 0);
   return row;
}

/*  */

/*  writeStr
** Bemerkung
** writes an string via VIO Routines to the screen
** (the strings must be not longer than the LINE_BUFFER constant!)
** The colors are untouched
**
** Parameter
** x,y                     screen position
** format                  printf formatstring
**
** Return
** 0        string was written
** !0       APIRET error code
**  */

int                        writeStr(int x, int y, char *format, ...)

{  APIRET                  rc;
   char                    lineBuffer[ LINE_BUFFER ];
   int                     length;
   va_list                 argPtr;


   va_start( argPtr, format );
   length = vsprintf( lineBuffer, format, argPtr );
   va_end( argPtr );

   rc = VioWrtCharStr( lineBuffer, length, y, x, 0 );
   return rc;
}

/*  */

/*  putString
** Bemerkung
** writes a raw string to the screen (without printf formatting
** and the LINE_BUFFER constraint)
**
**
** Parameter
** x,y                     screen position
** string                  raw date to be printed
**
** Return
** 0        string was written
** !0       APIRET error code
**  */

int                        putString(int x, int y, char *string)

{  APIRET                  rc;

   rc = VioWrtCharStr( string, strlen(string), y, x, 0 );
   return rc;
}

/*  */


/*  writeFullStr
** Bemerkung
** writes a string with current width of the screen (RIGHT)
** (and pads spaces if neccessary)
**
** Parameter
** x,y                     screen position
** format                  printf formatstring
** Return
** 0        string was written
** !0       APIRET error code
**  */

int                        writeFullStr(int x, int y, char *format, ...)

{  APIRET                  rc;
   char                    lineBuffer[ LINE_BUFFER ];
   int                     length,t;
   va_list                 argPtr;


   va_start( argPtr, format );
   length = vsprintf( lineBuffer, format, argPtr );
   va_end( argPtr );

   if ( gbl.filterControlChars )
      {  char           tempBuffer[ LINE_BUFFER ], *charPtr, *copyPtr;

      charPtr = lineBuffer;
      copyPtr = tempBuffer;
      while ( *charPtr )
         {
         if ( *charPtr > 31 )
            *copyPtr++ = *charPtr++;
         else
            *charPtr++;
         }
      *copyPtr = 0;

      strcpy( lineBuffer, tempBuffer );
      length = strlen( lineBuffer );
      }

   if (length > x + RIGHT )
      {
      length = RIGHT -x;
      rc = VioWrtCharStr( lineBuffer, length, y, x, 0 );
      }
   else
      {
      for (t=length; t < RIGHT; t++ )
         lineBuffer[t]=' ';
      lineBuffer[RIGHT+1]=0;
      rc = VioWrtCharStr( lineBuffer, RIGHT - x, y, x, 0 );
      }

   return rc;
}


/*  */



/*  scrollDown
** Bemerkung
** scroll the current screen x lines down (the statusline
** is not scrolled!)
**
**
** Parameter
** lines                   No. of lines
**
** Return
** 0        the screen was scrolled
** !0       APIRET error code
**  */

int                        scrollDown( int lines )

{  APIRET                  rc;
   char                    cell[2];

   cell[0] = 32;
   cell[1] = gbl.colors[gbl.colorSet][BACKGROUND];
   rc = VioScrollDn( 0, 0, BOTTOM - 1, RIGHT, lines, cell, 0 );
   return rc;
}

/*  */

/*  scrollUp
** Bemerkung
** scroll the current screen x lines up (the statusline
** is not scrolled!)
**
**
** Parameter
** lines                   No. of lines
**
** Return
** 0        the screen was scrolled
** !0       APIRET error code
**  */

int                        scrollUp(int lines )

{  APIRET                  rc;
   char                    cell[2];

   cell[0] = 32;
   cell[1] = gbl.colors[gbl.colorSet][BACKGROUND];

   rc = VioScrollUp( 0, 0, BOTTOM -1, RIGHT, lines, cell, 0 );
   return rc;
}

/*  */

/*  window
** Bemerkung
** creates a window with the specified frame and saves
** its background
**
**
** Parameter
** x,y                     upper left corner
** br                      width of window (effective width -2 because of the frame!)
** ho                      height of window (effective height -2 because of the frame!)
** frametype               frametype
** Return
** NULL        window was not allocated
** !NULL       window was alloceted
**  */

win *                      window(int x, int y, int br, int ho, enum e_frameType frametype )

{  win                     *newwin;

   newwin = malloc( sizeof(win) );
   if ( newwin )
      {
      newwin->x         = x;
      newwin->y         = y;
      newwin->br        = br;
      newwin->ho        = ho;
      newwin->frameType = frametype;
      newwin->background = copyscreen( x, y, br, ho );

      frame( x,y,br,ho, frametype );
      }

   return newwin;
}

/*  */

/*  closeWindow
** Bemerkung
** restore the background of the window
** and free all used resources
**
**
** Parameter
** window                  ptr to a win struct from window()
**
** Return
**
**  */

void                       closeWindow( win *window)

{
   if ( window && window->background )
      {
      copybuffer( window );
      free( window->background );
      free( window );
      }

}

/*  */



/*  copyscreen
** Bemerkung
** copy a rectangle to a char buffer. The buffer is allocated
** with malloc
**
** Parameter
** x,y                     screen position (upper left)
** br                      width
** ho                      height
** Return
** NULL        malloc failed
** !NULL       the copied screen
**  */

char *                     copyscreen(int x, int y, int br, int ho)

{  APIRET                  rc;
   char                    *buffer, *bufPtr;
   unsigned short          length=2*br;
   int                     t;

   buffer = malloc( ho * br * 2);
   if ( buffer )
      {
      bufPtr = buffer;

      for (t=0; t<ho; t++ )
         {
         rc = VioReadCellStr( bufPtr, &length, y+t, x, 0 );
         bufPtr += br*2;
         }
      return buffer;
      }
   return NULL;
}

/*  */

/*  copybuffer
** Bemerkung
** restore the background of a window
** (the position is readed from the ptr to a win struct
**
** Parameter
** window                  ptr from window()
**
** Return
**
**  */

void                       copybuffer( win *window)

{  APIRET                  rc;
   char                    *buffer, *bufPtr;
   unsigned short          length=2*window->br;
   int                     t;

   bufPtr = window->background;
   for (t=0; t < window->ho; t++ )
      {
      rc = VioWrtCellStr( bufPtr, length, window->y+t, window->x, 0 );
      bufPtr += window->br*2;
      }
}

/*  */



/*  frame
** Bemerkung
** draws a frame to the screen. The inner area of the
** frame is cleared with spaces (NO_FRAME does nothing!)
**
** Parameter
** x,y                     screen position (upper left)
** br                      width
** ho                      height
** frametype               type of the frame
** Return
**
**  */

void                       frame( int x, int y, int br, int ho, enum e_frameType frametype )

{  char                    line[256], *charset;
   int                     t,s;

   switch ( frametype )
      {
      default:
      case  NO_FRAME:                  return;

      case  SINGLE:                    charset = SINGLE_FRAME_CHAR;
                                       break;

      case  DOUBLE:                    charset = DOUBLE_FRAME_CHAR;
                                       break;
      }

   /*
   ** upperline
   */

   line[0] = UPPER_LEFT( charset );
   for (t=1; t<br-1; t++)
      line[t] = HORI_BAR( charset );
   line[t++] = UPPER_RIGHT( charset );
   line[t]=0;

   putString( x, y, line );
   paintArea( x, y+s, strlen(line), gbl.colors[gbl.colorSet][WINDOWFRAME] );

   /*
   ** middle lines
   */

   for (s=1; s<ho-1; s++)
      {
      line[0] = VERT_BAR( charset );
      for (t=1; t<br-1; t++)
         line[t]=' ';
      line[t++] = VERT_BAR( charset );
      line[t]=0;
      putString( x, y+s, line );
      paintArea( x, y+s, strlen(line), gbl.colors[gbl.colorSet][WINDOWFRAME] );
      }

   /*
   ** lowerline
   */

   line[0] = LOWER_LEFT( charset );
   for (t=1; t<br-1; t++)
      line[t] = HORI_BAR( charset );
   line[t++] = LOWER_RIGHT( charset );
   line[t]=0;

   putString( x, y+s, line );
   paintArea( x, y+s, strlen(line), gbl.colors[gbl.colorSet][WINDOWFRAME] );

}

/*  */

/*  message
** Bemerkung
** make a small window in the center of the screen
** and display a message
**
** Parameter
** format                  printf formatstring
**
** Return
** NULL        allocation of window failed
** !NULL       ptr to a win struct (must be closed with closeWindow!)
**  */

win *                      message( char *format, ... )

{  va_list                 argPtr;
   int                     length;
   char                    lineBuffer[128];
   win                     *msgWin;
   APIRET                  rc;

   va_start( argPtr, format );
   length = vsprintf( lineBuffer, format, argPtr );
   va_end( argPtr );

   msgWin = window( 39 - (length+4)/2, 10, length + 4, 3, SINGLE );
   if ( msgWin )
      {
      putString( 39 - length/2, 11, lineBuffer );
      return msgWin;
      }
   return NULL;
}

/*  */

/*  paintArea
** Bemerkung
** fills an line with a color
**
** Parameter
** x,y                     screen position (upper left)
** length                  length of the line
** color                   the color attribute
** Return
** 0        the screen was painted
** !0       APIRET error code
**  */

int                        paintArea( int x, int y, int length, char color)

{
   return VioWrtNAttr( &color, length, y, x, 0 );
}

/*  */


