// Datei: lesscfg.cpp
// (c) Copyright 1997 by bns
// angegelegt am 2/5/1998
//
// PM config app for less (quick and really dirty :) )
// This programm is not really portable due the
// use of IOC (IBM Open Classlibraries)
//
// RCS: $Id: LESSCFG.CPP.# 1.1 1998/02/28 09:52:29 CBENDEN Exp $
//
// Datei
//   Datei-Log 
//  $Log: LESSCFG.CPP.# $
//Revision 1.1  1998/02/28  09:52:29  CBENDEN
//Initial revision
//
//   Datei-Log Ende 


//  *** Local Defines ***

   #define  LESSCFG                    1

//  *** Includes ***

      #ifndef  RELEASE

         #define     IC_TRACE_DEVELOP

      #endif

      #include    <Iapp.hpp>
      #include    <Icheckbx.hpp>
      #include    <Icmdhdr.hpp>
      #include    <Icolor.hpp>
      #include    <Icombobx.hpp>
      #include    <Iexcbase.hpp>
      #include    <Iframe.hpp>
      #include    <Imsgbox.hpp>
      #include    <Ipainhdr.hpp>
      #include    <Iprofile.hpp>
      #include    <Ipushbut.hpp>
      #include    <Iradiobt.hpp>
      #include    <Iselhdr.hpp>
      #include    <Istattxt.hpp>
      #include    <Ititle.hpp>
      #include    <Itrace.hpp>
      #include    <Iwindow.hpp>

      #include    "..\include\defines.def"
      #include    "lesscfg.h"

//  *** Globals / Statics ***

//  *** Externals ***

//  *** Prototypes ***


class lesscfg
   : public IFrameWindow,
     public ICommandHandler,
     public IPaintHandler,
     public ISelectHandler
   {

      // ***
      // *** PUBLIC
      // ***
      public:
         lesscfg();
         ~lesscfg();

         IString                       msg( int msgId, char *txt1=NULL, char *txt2=NULL, char *txt3=NULL, char *txt4=NULL, char *txt5=NULL, char *txt6=NULL, char *txt7=NULL, char *txt8=NULL, char *txt9=NULL, char *txt10=NULL);

      // ***
      // ***   PROTECTED
      // ***
      protected:
         Boolean                       command( ICommandEvent &evt );
         Boolean                       paintWindow( IPaintEvent &evt );
         Boolean                       selected( IControlEvent &evt );

         IColor                        colorFromInt( int color );
         void                          loadIni();
         void                          readIni_10( IProfile &lessinit );
         void                          saveIni();
         void                          setupColors();

      // ***
      // ***   PRIVATE:
      // ***
      private:
         globalData                    gbl;
         IRadioButton                  colorSet, monoSet, fullLine, partial;
         ICheckBox                     showControl;
         IStaticText                   background, background_V, background_H,
                                       windowframe, windowframe_V, windowframe_H,
                                       normaltext, normaltext_V, normaltext_H,
                                       hilitetext, hilitetext_V, hilitetext_H,
                                       entryfield, entryfield_V, entryfield_H,
                                       statusline, statusline_V, statusline_H,
                                       markedline, markedline_V, markedline_H
                                       ;
         ITitle                        title;
   };


//  lesscfg::lesscfg
// Bemerkung
//
//
//
//
// Parameter
//
//
// Return
//
// 

lesscfg::lesscfg()
   :  IFrameWindow(  DLG_LESS, IFrameWindow::dialogResource ), // IFrameWindow::windowList ),
      colorSet(      LESSOPT_COLOR, this ),
      monoSet(       LESSOPT_BLACKWHITE, this ),
      fullLine(      LESSOPT_FULLLINE, this ),
      partial(       LESSOPT_PARTIAL, this ),
      showControl(   LESSOPT_SHOWCONTROLCHARS, this ),
      background(    LESSOPT_BACKGROUND, this ),
      background_V(  LESSOPT_BACKGROUND_V, this ),
      background_H(  LESSOPT_BACKGROUND_H, this ),
      windowframe(   LESSOPT_WINDOWFRAME, this ),
      windowframe_V( LESSOPT_WINDOWFRAME_V, this ),
      windowframe_H( LESSOPT_WINDOWFRAME_H, this ),
      normaltext(    LESSOPT_NORMALTEXT, this ),
      normaltext_V(  LESSOPT_NORMALTEXT_V, this ),
      normaltext_H(  LESSOPT_NORMALTEXT_H, this ),
      hilitetext(    LESSOPT_HILITETEXT, this ),
      hilitetext_V(  LESSOPT_HILITETEXT_V, this ),
      hilitetext_H(  LESSOPT_HILITETEXT_H, this ),
      entryfield(    LESSOPT_ENTRYFIELD, this ),
      entryfield_V(  LESSOPT_ENTRYFIELD_V, this ),
      entryfield_H(  LESSOPT_ENTRYFIELD_H, this ),
      statusline(    LESSOPT_STATUSLINE, this ),
      statusline_V(  LESSOPT_STATUSLINE_V, this ),
      statusline_H(  LESSOPT_STATUSLINE_H, this ),
      markedline(    LESSOPT_MARKEDLINE, this ),
      markedline_V(  LESSOPT_MARKEDLINE_V, this ),
      markedline_H(  LESSOPT_MARKEDLINE_H, this ),

      title(         this )
{
   IFUNCTRACE_DEVELOP();

   ICommandHandler::handleEventsFor( this );

   IPaintHandler::handleEventsFor(&background_V);
   IPaintHandler::handleEventsFor(&background_H);
   IPaintHandler::handleEventsFor(&windowframe_V);
   IPaintHandler::handleEventsFor(&windowframe_H);
   IPaintHandler::handleEventsFor(&normaltext_V);
   IPaintHandler::handleEventsFor(&normaltext_H);
   IPaintHandler::handleEventsFor(&hilitetext_V);
   IPaintHandler::handleEventsFor(&hilitetext_H);
   IPaintHandler::handleEventsFor(&entryfield_V);
   IPaintHandler::handleEventsFor(&entryfield_H);
   IPaintHandler::handleEventsFor(&statusline_V);
   IPaintHandler::handleEventsFor(&statusline_H);
   IPaintHandler::handleEventsFor(&markedline_V);
   IPaintHandler::handleEventsFor(&markedline_H);

   ISelectHandler::handleEventsFor( &colorSet );
   ISelectHandler::handleEventsFor( &monoSet );

   title.setText( msg(MSG_LESSCFG_WINDOWTITLE) );

   loadIni();

   if ( gbl.colorSet == COLOUR )
      colorSet.select();
   else
      monoSet.select();

   if ( gbl.showFullLine )
      fullLine.select();
   else
      partial.select();

   if (!gbl.filterControlChars)
      showControl.select();

   setupColors();

   /*
   **  some wps magic - open color palette
   ** (id's can be found in \os2\ini.rc !)
   */

   HOBJECT              objHandle;
   objHandle = WinQueryObject( "<WP_LORESCLRPAL>" );
   if ( objHandle )
      // Open in default view
      WinOpenObject( objHandle, 0, TRUE );

   /*
   ** center window on desktop
   */

   ISize                   deskSize = desktopWindow()->size();
   moveTo( IPoint( deskSize.width()/2 - size().width()/2, deskSize.height()/2 - size().height()/2 )  );

   colorSet.setFocus();
   show();
}

// 

//  lesscfg::~lesscfg
// Bemerkung
//
//
//
//
// Parameter
//
//
// Return
//
// 

lesscfg::~lesscfg()

{
   IFUNCTRACE_DEVELOP();

   ICommandHandler::stopHandlingEventsFor( this );

   IPaintHandler::stopHandlingEventsFor( &background_V);
   IPaintHandler::stopHandlingEventsFor( &background_H);
   IPaintHandler::stopHandlingEventsFor( &windowframe_V);
   IPaintHandler::stopHandlingEventsFor( &windowframe_H);
   IPaintHandler::stopHandlingEventsFor( &normaltext_V);
   IPaintHandler::stopHandlingEventsFor( &normaltext_H);
   IPaintHandler::stopHandlingEventsFor( &hilitetext_V);
   IPaintHandler::stopHandlingEventsFor( &hilitetext_H);
   IPaintHandler::stopHandlingEventsFor( &entryfield_V);
   IPaintHandler::stopHandlingEventsFor( &entryfield_H);
   IPaintHandler::stopHandlingEventsFor( &statusline_V);
   IPaintHandler::stopHandlingEventsFor( &statusline_H);
   IPaintHandler::stopHandlingEventsFor( &markedline_V);
   IPaintHandler::stopHandlingEventsFor( &markedline_H);

   ISelectHandler::stopHandlingEventsFor( &colorSet );
   ISelectHandler::stopHandlingEventsFor( &monoSet );
}

// 

//  lesscfg::command
// Bemerkung
// handle alle WM_COMMAND events from the child
// windows
// (this is an overrided handlerfunction)
//
// Parameter
//
//
// Return
// true        the event was handled by application
// false       call next handler
// 

Boolean                    lesscfg::command( ICommandEvent &evt )

{
   IFUNCTRACE_DEVELOP();

   switch ( evt.commandId() )
      {
      case  LESSOPT_CANCEL:            /*
                                       ** close app (NO SAVE!)
                                       */

                                       close();
                                       return true;

      case  LESSOPT_OK:                /*
                                       ** close app and save changes
                                       */

                                       saveIni();
                                       close();
                                       return true;
      }

   return false;
}

// 


//  lesscfg::paintWindow
// Bemerkung
// get the WM_PAINT event to update the color
// of the correspondig IStaticText
// (this is an overrided handlerfunction)
//
// Parameter
//
//
// Return
// true        the event was handled by application
// false       call next handler
// 

Boolean                    lesscfg::paintWindow( IPaintEvent &evt )

{
   IFUNCTRACE_DEVELOP();

   switch ( evt.window()->id() )
      {
      case  LESSOPT_BACKGROUND_V:         background.setForegroundColor(   background_V.backgroundColor() ); break;
      case  LESSOPT_BACKGROUND_H:         background.setBackgroundColor(   background_H.backgroundColor() ); break;
      case  LESSOPT_WINDOWFRAME_V:        windowframe.setForegroundColor(  windowframe_V.backgroundColor() ); break;
      case  LESSOPT_WINDOWFRAME_H:        windowframe.setBackgroundColor(  windowframe_H.backgroundColor() ); break;
      case  LESSOPT_NORMALTEXT_V:         normaltext.setForegroundColor(   normaltext_V.backgroundColor() ); break;
      case  LESSOPT_NORMALTEXT_H:         normaltext.setBackgroundColor(   normaltext_H.backgroundColor() ); break;
      case  LESSOPT_HILITETEXT_V:         hilitetext.setForegroundColor(   hilitetext_V.backgroundColor() ); break;
      case  LESSOPT_HILITETEXT_H:         hilitetext.setBackgroundColor(   hilitetext_H.backgroundColor() ); break;
      case  LESSOPT_ENTRYFIELD_V:         entryfield.setForegroundColor(   entryfield_V.backgroundColor() ); break;
      case  LESSOPT_ENTRYFIELD_H:         entryfield.setBackgroundColor(   entryfield_H.backgroundColor() ); break;
      case  LESSOPT_STATUSLINE_V:         statusline.setForegroundColor(   statusline_V.backgroundColor() ); break;
      case  LESSOPT_STATUSLINE_H:         statusline.setBackgroundColor(   statusline_H.backgroundColor() ); break;
      case  LESSOPT_MARKEDLINE_V:         markedline.setForegroundColor(   markedline_V.backgroundColor() ); break;
      case  LESSOPT_MARKEDLINE_H:         markedline.setBackgroundColor(   markedline_H.backgroundColor() ); break;
      }

   /*
   ** all we want is an information, when the color has
   ** changed, so return false an let do OS/2
   ** system the rest ...
   */

   return false;
}

// 

//  lesscfg::selected
// Bemerkung
// take care of the selection of the two radiobuttons
// which select the actual colorSet
// (this is an overrided handlerfunction)
//
// Parameter
//
//
// Return
// true        the event was handled by application
// false       call next handler
// 

Boolean                    lesscfg::selected( IControlEvent &evt )

{
   switch ( evt.controlId() )
      {
      case  LESSOPT_COLOR:             gbl.colorSet = COLOUR;
                                       setupColors();
                                       break;

      case  LESSOPT_BLACKWHITE:        gbl.colorSet = MONO;
                                       setupColors();
                                       break;
      }
   return false;
}

// 


//  lesscfg::setupColors
// Bemerkung
// change the colors of the static textfields according
// to the acutal colorSet
//
// Parameter
//
//
// Return
//
// 

void                       lesscfg::setupColors()

{
   IFUNCTRACE_DEVELOP();

   background.setForegroundColor(   colorFromInt(gbl.colors[gbl.colorSet][BACKGROUND] & 15) );
   background.setBackgroundColor(   colorFromInt(gbl.colors[gbl.colorSet][BACKGROUND] >> 4) );
   background_V.setBackgroundColor( colorFromInt(gbl.colors[gbl.colorSet][BACKGROUND] & 15) );
   background_H.setBackgroundColor( colorFromInt(gbl.colors[gbl.colorSet][BACKGROUND] >> 4) );

   windowframe.setForegroundColor(  colorFromInt(gbl.colors[gbl.colorSet][WINDOWFRAME] & 15) );
   windowframe.setBackgroundColor(  colorFromInt(gbl.colors[gbl.colorSet][WINDOWFRAME] >> 4) );
   windowframe_V.setBackgroundColor( colorFromInt(gbl.colors[gbl.colorSet][WINDOWFRAME] & 15) );
   windowframe_H.setBackgroundColor( colorFromInt(gbl.colors[gbl.colorSet][WINDOWFRAME] >> 4) );

   normaltext.setForegroundColor(   colorFromInt(gbl.colors[gbl.colorSet][NORMALTEXT] & 15) );
   normaltext.setBackgroundColor(   colorFromInt(gbl.colors[gbl.colorSet][NORMALTEXT] >> 4) );
   normaltext_V.setBackgroundColor( colorFromInt(gbl.colors[gbl.colorSet][NORMALTEXT] & 15) );
   normaltext_H.setBackgroundColor( colorFromInt(gbl.colors[gbl.colorSet][NORMALTEXT] >> 4) );

   hilitetext.setForegroundColor(   colorFromInt(gbl.colors[gbl.colorSet][HILITETEXT] & 15) );
   hilitetext.setBackgroundColor(   colorFromInt(gbl.colors[gbl.colorSet][HILITETEXT] >> 4) );
   hilitetext_V.setBackgroundColor( colorFromInt(gbl.colors[gbl.colorSet][HILITETEXT] & 15) );
   hilitetext_H.setBackgroundColor( colorFromInt(gbl.colors[gbl.colorSet][HILITETEXT] >> 4) );

   entryfield.setForegroundColor(   colorFromInt(gbl.colors[gbl.colorSet][ENTRYFIELD] & 15) );
   entryfield.setBackgroundColor(   colorFromInt(gbl.colors[gbl.colorSet][ENTRYFIELD] >> 4) );
   entryfield_V.setBackgroundColor( colorFromInt(gbl.colors[gbl.colorSet][ENTRYFIELD] & 15) );
   entryfield_H.setBackgroundColor( colorFromInt(gbl.colors[gbl.colorSet][ENTRYFIELD] >> 4) );

   statusline.setForegroundColor(   colorFromInt(gbl.colors[gbl.colorSet][STATUSLINE] & 15) );
   statusline.setBackgroundColor(   colorFromInt(gbl.colors[gbl.colorSet][STATUSLINE] >> 4) );
   statusline_V.setBackgroundColor( colorFromInt(gbl.colors[gbl.colorSet][STATUSLINE] & 15) );
   statusline_H.setBackgroundColor( colorFromInt(gbl.colors[gbl.colorSet][STATUSLINE] >> 4) );

   markedline.setForegroundColor(   colorFromInt(gbl.colors[gbl.colorSet][MARKEDLINE] & 15) );
   markedline.setBackgroundColor(   colorFromInt(gbl.colors[gbl.colorSet][MARKEDLINE] >> 4) );
   markedline_V.setBackgroundColor( colorFromInt(gbl.colors[gbl.colorSet][MARKEDLINE] & 15) );
   markedline_H.setBackgroundColor( colorFromInt(gbl.colors[gbl.colorSet][MARKEDLINE] >> 4) );

}

// 



//  lesscfg::colorFromInt
// Bemerkung
//
//
//
//
// Parameter
//
//
// Return
//
// 

IColor                     lesscfg::colorFromInt( int color )

{
   switch ( color )
      {
      case  0:             return IColor::black;
      case  1:             return IColor::darkBlue;
      case  2:             return IColor::darkGreen;
      case  3:             return IColor::darkCyan;
      case  4:             return IColor::darkRed;
      case  5:             return IColor::darkPink;
      case  6:             return IColor::brown;
      case  7:             return IColor::paleGray;
      case  8:             return IColor::darkGray;
      case  9:             return IColor::blue;
      case 10:             return IColor::green;
      case 11:             return IColor::cyan;
      case 12:             return IColor::red;
      case 13:             return IColor::pink;
      case 14:             return IColor::yellow;
      case 15:             return IColor::white;
      }
   return IColor::black;
}

// 



//  lesscfg::loadIni
// Bemerkung
//
//
//
//
// Parameter
//
//
// Return
//
// 

void                       lesscfg::loadIni(void)

{  Boolean                 versionCorrect = false;
   IString                 iniVersion;

   IString                 path = getenv( "ETC" ) + IString("\\less.ini" );
   IProfile                lessini( path );

   IFUNCTRACE_DEVELOP();

   try
      {
      lessini.setDefaultApplicationName( "LESS" );

      iniVersion                 = lessini.elementWithKey(  "INIVERSION" );

      if ( iniVersion == INI_VERSION_10 )
         {
         versionCorrect = true;
         readIni_10( lessini );
         }
      }

   catch (IException& exc)
      {

      IMessageBox          warnung( IWindow::desktopWindow() );

      /*
      ** only display exceptions, that are not
      ** caused due a missing ini file
      */

      if (exc.errorId() != 4868 )
         warnung.show( exc );

      warnung.show( msg(MSG_LESSCFG_INITNOTEXIST) , IMessageBox::okButton );

      memset( &gbl, 0, sizeof(gbl) );

      gbl.filterControlChars     = 1;
      gbl.showFindResults        = 1;
      gbl.showFullLine           = 1;

      gbl.bottom                 = 24;
      gbl.right                  = 79;

      gbl.hexChunk               = 16;
      gbl.hexPage                = gbl.hexChunk * (gbl.bottom-1);

      /*
      ** Colors
      */

      gbl.colors[MONO][BACKGROUND]     = 0x07;
      gbl.colors[MONO][WINDOWFRAME]    = 0x07;
      gbl.colors[MONO][NORMALTEXT]     = 0x07;
      gbl.colors[MONO][HILITETEXT]     = 0x0F;
      gbl.colors[MONO][ENTRYFIELD]     = 0x70;
      gbl.colors[MONO][STATUSLINE]     = 0x70;
      gbl.colors[MONO][MARKEDLINE]     = 0x20;

      gbl.colors[COLOUR][BACKGROUND]    = 0x1F;
      gbl.colors[COLOUR][WINDOWFRAME]   = 0x1F;
      gbl.colors[COLOUR][NORMALTEXT]    = 0x17;
      gbl.colors[COLOUR][HILITETEXT]    = 0x1E;
      gbl.colors[COLOUR][ENTRYFIELD]    = 0x3E;
      gbl.colors[COLOUR][STATUSLINE]    = 0x73;
      gbl.colors[COLOUR][MARKEDLINE]    = 0x72;


      saveIni();
      }

   ITRACE_DEVELOP( "verlasse lesscfg::loadIni" );
}

// 

//  lesscfg::readIni_10
// Bemerkung
//
//
//
//
// Parameter
//
//
// Return
//
// 

void                       lesscfg::readIni_10( IProfile &lessini )

{  int                     t;

   IFUNCTRACE_DEVELOP();

   gbl.colorSet = lessini.integerWithKey( "COLORSET" );

   for (t=0; t<MAX_COLORSET; t++)
      {

      lessini.setDefaultApplicationName( "COLOURSET-" + IString(t) );

      gbl.colors[t][BACKGROUND]     = lessini.integerWithKey( "BACKGROUND" );
      gbl.colors[t][WINDOWFRAME]    = lessini.integerWithKey( "WINDOWFRAME" );
      gbl.colors[t][NORMALTEXT]     = lessini.integerWithKey( "NORMALTEXT" );
      gbl.colors[t][HILITETEXT]     = lessini.integerWithKey( "HILITETEXT" );
      gbl.colors[t][ENTRYFIELD]     = lessini.integerWithKey( "ENTRYFIELD" );
      gbl.colors[t][STATUSLINE]     = lessini.integerWithKey( "STATUSLINE" );
      gbl.colors[t][MARKEDLINE]     = lessini.integerWithKey( "MARKEDLINE" );
      }

   lessini.setDefaultApplicationName( "TOGGLES" );

   gbl.filterControlChars           = lessini.integerWithKey( "SHOWCONTROLCHARS" );
   gbl.showFindResults              = lessini.integerWithKey( "SHOWFINDRESULTS" );
   gbl.showFullLine                 = lessini.integerWithKey( "SHOWFULLLINE" );

}

// 


//  lesscfg::saveIni
// Bemerkung
//
//
//
//
// Parameter
//
//
// Return
//
// 

void                       lesscfg::saveIni()

{  int                     t;
   IString                 path = getenv( "ETC" ) + IString("\\less.ini" );
   IProfile                lessini( path );

   IFUNCTRACE_DEVELOP();
   try
      {

      lessini.setDefaultApplicationName( "LESS" );

      lessini.addOrReplaceElementWithKey( "INIVERSION"     , CURRENT_INI_VERSION  );
      lessini.addOrReplaceElementWithKey( "COLORSET"       , int(gbl.colorSet)  );

      for (t=0; t<MAX_COLORSET; t++)
         {

         lessini.setDefaultApplicationName( "COLOURSET-" + IString(t) );

         lessini.addOrReplaceElementWithKey( "BACKGROUND"    , gbl.colors[t][BACKGROUND]   );
         lessini.addOrReplaceElementWithKey( "WINDOWFRAME"   , gbl.colors[t][WINDOWFRAME]  );
         lessini.addOrReplaceElementWithKey( "NORMALTEXT"    , gbl.colors[t][NORMALTEXT]   );
         lessini.addOrReplaceElementWithKey( "HILITETEXT"    , gbl.colors[t][HILITETEXT]   );
         lessini.addOrReplaceElementWithKey( "ENTRYFIELD"    , gbl.colors[t][ENTRYFIELD]   );
         lessini.addOrReplaceElementWithKey( "STATUSLINE"    , gbl.colors[t][STATUSLINE]   );
         lessini.addOrReplaceElementWithKey( "MARKEDLINE"    , gbl.colors[t][MARKEDLINE]   );

         }

      lessini.setDefaultApplicationName( "TOGGLES" );

      lessini.addOrReplaceElementWithKey( "SHOWCONTROLCHARS" , int( showControl.isSelected())  );
      lessini.addOrReplaceElementWithKey( "SHOWFINDRESULTS"  , gbl.showFindResults );
      lessini.addOrReplaceElementWithKey( "SHOWFULLLINE"     , int(fullLine.isSelected()) );

      }

   catch (IException& exc)
      {
      IMessageBox warnung( IWindow::desktopWindow() );

      warnung.show( msg(MSG_LESSCFG_ERROR_SAVEINI) , IMessageBox::okButton );
      }

}

// 



//  lesscfg::msg
// Bemerkung
//
//
//
//
// Parameter
//
//
// Return
//
// 

IString                    lesscfg::msg( int msgId, char *txt1, char *txt2, char *txt3, char *txt4, char *txt5, char *txt6, char *txt7, char *txt8, char *txt9, char *txt10)

{  static char             msgBuffer[ 512 ];
   APIRET                  rc;
   ULONG                   varsUsed, outputLength;
   char                    *varsTable[10];
   int                     t;

   IFUNCTRACE_DEVELOP();

   varsTable[0] = txt1;
   varsTable[1] = txt2;
   varsTable[2] = txt3;
   varsTable[3] = txt4;
   varsTable[4] = txt5;
   varsTable[5] = txt6;
   varsTable[6] = txt7;
   varsTable[7] = txt8;
   varsTable[8] = txt9;
   varsTable[9] = txt10;

   varsUsed = 0;
   for (t=0; t<10; t++)
      if ( varsTable[t] )
         varsUsed++;

   outputLength = 0;

   memset( msgBuffer, 0, sizeof(msgBuffer) );
   rc = DosGetMessage( varsTable,
                       varsUsed,
                       msgBuffer,
                       sizeof( msgBuffer ),
                       msgId,
                       (PSZ) "less.msg",
                       &outputLength
                     );
   return msgBuffer;
}

// 


//  main
// Bemerkung
// main...
//
// Parameter
//
//
// Return
// errorlevel to an real operating system
// 

int                        main()

{
   try
      {  lesscfg           appWindow;

      IApplication::current().run();
      }


   catch (IException& exc)
      {
      IMessageBox          warnung( IWindow::desktopWindow() );

      warnung.setTitle( "lesscfg excption" );
      warnung.show( exc );
      }

   return 0;

}

// 



